package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class NodeSpecBuilder extends NodeSpecFluent<NodeSpecBuilder> implements VisitableBuilder<NodeSpec,NodeSpecBuilder>{

     NodeSpecFluent<?> fluent;
public NodeSpecBuilder(){
    this(new NodeSpec());
}
public NodeSpecBuilder( NodeSpecFluent<?> fluent ){
    this(fluent, new NodeSpec());
}
public NodeSpecBuilder( NodeSpecFluent<?> fluent , NodeSpec instance ){
    this.fluent = fluent; fluent.withExternalID(instance.getExternalID()); fluent.withPodCIDR(instance.getPodCIDR()); fluent.withProviderID(instance.getProviderID()); fluent.withUnschedulable(instance.getUnschedulable()); 
}
public NodeSpecBuilder( NodeSpec instance ){
    this.fluent = this; this.withExternalID(instance.getExternalID()); this.withPodCIDR(instance.getPodCIDR()); this.withProviderID(instance.getProviderID()); this.withUnschedulable(instance.getUnschedulable()); 
}

public EditableNodeSpec build(){
    EditableNodeSpec buildable = new EditableNodeSpec(fluent.getExternalID(),fluent.getPodCIDR(),fluent.getProviderID(),fluent.isUnschedulable());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    