/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.EditableBuildRequest;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildRequestBuilder
extends BuildRequestFluent<BuildRequestBuilder>
implements VisitableBuilder<BuildRequest, BuildRequestBuilder> {
    BuildRequestFluent<?> fluent;

    public BuildRequestBuilder() {
        this(new BuildRequest());
    }

    public BuildRequestBuilder(BuildRequestFluent<?> fluent) {
        this(fluent, new BuildRequest());
    }

    public BuildRequestBuilder(BuildRequestFluent<?> fluent, BuildRequest instance) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRevision(instance.getRevision());
        fluent.withTriggeredByImage(instance.getTriggeredByImage());
    }

    public BuildRequestBuilder(BuildRequest instance) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRevision(instance.getRevision());
        this.withTriggeredByImage(instance.getTriggeredByImage());
    }

    @Override
    public EditableBuildRequest build() {
        EditableBuildRequest buildable = new EditableBuildRequest(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRevision(), this.fluent.getTriggeredByImage());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

