
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "author",
    "commit",
    "committer",
    "message"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class GitSourceRevision {

    /**
     * 
     * 
     */
    @JsonProperty("author")
    @Valid
    private SourceControlUser author;
    /**
     * hash identifying a specific commit
     * 
     */
    @JsonProperty("commit")
    private String commit;
    /**
     * 
     * 
     */
    @JsonProperty("committer")
    @Valid
    private SourceControlUser committer;
    /**
     * description of a specific commit
     * 
     */
    @JsonProperty("message")
    private String message;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public GitSourceRevision() {
    }

    /**
     * 
     * @param message
     * @param author
     * @param commit
     * @param committer
     */
    public GitSourceRevision(SourceControlUser author, String commit, SourceControlUser committer, String message) {
        this.author = author;
        this.commit = commit;
        this.committer = committer;
        this.message = message;
    }

    /**
     * 
     * 
     * @return
     *     The author
     */
    @JsonProperty("author")
    public SourceControlUser getAuthor() {
        return author;
    }

    /**
     * 
     * 
     * @param author
     *     The author
     */
    @JsonProperty("author")
    public void setAuthor(SourceControlUser author) {
        this.author = author;
    }

    /**
     * hash identifying a specific commit
     * 
     * @return
     *     The commit
     */
    @JsonProperty("commit")
    public String getCommit() {
        return commit;
    }

    /**
     * hash identifying a specific commit
     * 
     * @param commit
     *     The commit
     */
    @JsonProperty("commit")
    public void setCommit(String commit) {
        this.commit = commit;
    }

    /**
     * 
     * 
     * @return
     *     The committer
     */
    @JsonProperty("committer")
    public SourceControlUser getCommitter() {
        return committer;
    }

    /**
     * 
     * 
     * @param committer
     *     The committer
     */
    @JsonProperty("committer")
    public void setCommitter(SourceControlUser committer) {
        this.committer = committer;
    }

    /**
     * description of a specific commit
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * description of a specific commit
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(author).append(commit).append(committer).append(message).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof GitSourceRevision) == false) {
            return false;
        }
        GitSourceRevision rhs = ((GitSourceRevision) other);
        return new EqualsBuilder().append(author, rhs.author).append(commit, rhs.commit).append(committer, rhs.committer).append(message, rhs.message).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
