package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class DeploymentConfigStatusFluent<T extends DeploymentConfigStatusFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<DeploymentDetails, ?> details;     Integer latestVersion;     Map<String, Object> additionalProperties = new HashMap();

    public DeploymentDetails getDetails(){
    return this.details!=null?this.details.build():null;
    }
    public T withDetails( DeploymentDetails details){
    if (details!=null){ this.details= new DeploymentDetailsBuilder(details); _visitables.add(this.details);} return (T) this;
    }
    public DetailsNested<T> withNewDetails(){
    return new DetailsNested<T>();
    }
    public DetailsNested<T> withNewDetailsLike( DeploymentDetails item){
    return new DetailsNested<T>(item);
    }
    public DetailsNested<T> editDetails(){
    return withNewDetailsLike(getDetails());
    }
    public Integer getLatestVersion(){
    return this.latestVersion;
    }
    public T withLatestVersion( Integer latestVersion){
    this.latestVersion=latestVersion; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class DetailsNested<N> extends DeploymentDetailsFluent<DetailsNested<N>> implements Nested<N>{

        private final DeploymentDetailsBuilder builder;
    
             DetailsNested (){
        this.builder = new DeploymentDetailsBuilder(this);
        }
             DetailsNested ( DeploymentDetails item){
        this.builder = new DeploymentDetailsBuilder(this, item);
        }
    
            public N and(){
            return (N) DeploymentConfigStatusFluent.this.withDetails(builder.build());
        }
            public N endDetails(){
            return and();
        }
    
}


}
