
package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.EnvVar;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "command",
    "environment",
    "image"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class CustomDeploymentStrategyParams {

    /**
     * optionally overrides the container command (default is specified by the image)
     * 
     */
    @JsonProperty("command")
    @Valid
    private List<String> command = new ArrayList<String>();
    /**
     * environment variables provided to the deployment process container
     * 
     */
    @JsonProperty("environment")
    @Valid
    private List<EnvVar> environment = new ArrayList<EnvVar>();
    /**
     * a Docker image which can carry out a deployment
     * 
     */
    @JsonProperty("image")
    private String image;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public CustomDeploymentStrategyParams() {
    }

    /**
     * 
     * @param environment
     * @param command
     * @param image
     */
    public CustomDeploymentStrategyParams(List<String> command, List<EnvVar> environment, String image) {
        this.command = command;
        this.environment = environment;
        this.image = image;
    }

    /**
     * optionally overrides the container command (default is specified by the image)
     * 
     * @return
     *     The command
     */
    @JsonProperty("command")
    public List<String> getCommand() {
        return command;
    }

    /**
     * optionally overrides the container command (default is specified by the image)
     * 
     * @param command
     *     The command
     */
    @JsonProperty("command")
    public void setCommand(List<String> command) {
        this.command = command;
    }

    /**
     * environment variables provided to the deployment process container
     * 
     * @return
     *     The environment
     */
    @JsonProperty("environment")
    public List<EnvVar> getEnvironment() {
        return environment;
    }

    /**
     * environment variables provided to the deployment process container
     * 
     * @param environment
     *     The environment
     */
    @JsonProperty("environment")
    public void setEnvironment(List<EnvVar> environment) {
        this.environment = environment;
    }

    /**
     * a Docker image which can carry out a deployment
     * 
     * @return
     *     The image
     */
    @JsonProperty("image")
    public String getImage() {
        return image;
    }

    /**
     * a Docker image which can carry out a deployment
     * 
     * @param image
     *     The image
     */
    @JsonProperty("image")
    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(command).append(environment).append(image).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof CustomDeploymentStrategyParams) == false) {
            return false;
        }
        CustomDeploymentStrategyParams rhs = ((CustomDeploymentStrategyParams) other);
        return new EqualsBuilder().append(command, rhs.command).append(environment, rhs.environment).append(image, rhs.image).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
