package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class GitRepoVolumeSourceBuilder extends GitRepoVolumeSourceFluent<GitRepoVolumeSourceBuilder> implements VisitableBuilder<GitRepoVolumeSource,GitRepoVolumeSourceBuilder>{

     GitRepoVolumeSourceFluent<?> fluent;
public GitRepoVolumeSourceBuilder(){
    this(new GitRepoVolumeSource());
}
public GitRepoVolumeSourceBuilder( GitRepoVolumeSourceFluent<?> fluent ){
    this(fluent, new GitRepoVolumeSource());
}
public GitRepoVolumeSourceBuilder( GitRepoVolumeSourceFluent<?> fluent , GitRepoVolumeSource instance ){
    this.fluent = fluent; fluent.withRepository(instance.getRepository()); fluent.withRevision(instance.getRevision()); 
}
public GitRepoVolumeSourceBuilder( GitRepoVolumeSource instance ){
    this.fluent = this; this.withRepository(instance.getRepository()); this.withRevision(instance.getRevision()); 
}

public EditableGitRepoVolumeSource build(){
    EditableGitRepoVolumeSource buildable = new EditableGitRepoVolumeSource(fluent.getRepository(),fluent.getRevision());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    