package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class PersistentVolumeClaimListFluent<T extends PersistentVolumeClaimListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     PersistentVolumeClaimList.ApiVersion apiVersion;     List<VisitableBuilder<PersistentVolumeClaim, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public PersistentVolumeClaimList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( PersistentVolumeClaimList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( PersistentVolumeClaim item){
    if (item != null) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public List<PersistentVolumeClaim> getItems(){
    return build(items);
    }
    public T withItems( List<PersistentVolumeClaim> items){
    this.items.clear();if (items != null) {for (PersistentVolumeClaim item : items){this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNested<T>();
    }
    public ItemsNested<T> addNewItemLike( PersistentVolumeClaim item){
    return new ItemsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class ItemsNested<N> extends PersistentVolumeClaimFluent<ItemsNested<N>> implements Nested<N>{

        private final PersistentVolumeClaimBuilder builder;
    
             ItemsNested (){
        this.builder = new PersistentVolumeClaimBuilder(this);
        }
             ItemsNested ( PersistentVolumeClaim item){
        this.builder = new PersistentVolumeClaimBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeClaimListFluent.this.addToItems(builder.build());
        }
            public N endItem(){
            return and();
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) PersistentVolumeClaimListFluent.this.withMetadata(builder.build());
        }
    
}


}
