
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "intervalSeconds",
    "post",
    "pre",
    "timeoutSeconds",
    "updatePeriodSeconds"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class RollingDeploymentStrategyParams {

    /**
     * the time to wait between polling deployment status after update
     * 
     */
    @JsonProperty("intervalSeconds")
    private Long intervalSeconds;
    /**
     * 
     * 
     */
    @JsonProperty("post")
    @Valid
    private LifecycleHook post;
    /**
     * 
     * 
     */
    @JsonProperty("pre")
    @Valid
    private LifecycleHook pre;
    /**
     * the time to wait for updates before giving up
     * 
     */
    @JsonProperty("timeoutSeconds")
    private Long timeoutSeconds;
    /**
     * the time to wait between individual pod updates
     * 
     */
    @JsonProperty("updatePeriodSeconds")
    private Long updatePeriodSeconds;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public RollingDeploymentStrategyParams() {
    }

    /**
     * 
     * @param timeoutSeconds
     * @param post
     * @param intervalSeconds
     * @param pre
     * @param updatePeriodSeconds
     */
    public RollingDeploymentStrategyParams(Long intervalSeconds, LifecycleHook post, LifecycleHook pre, Long timeoutSeconds, Long updatePeriodSeconds) {
        this.intervalSeconds = intervalSeconds;
        this.post = post;
        this.pre = pre;
        this.timeoutSeconds = timeoutSeconds;
        this.updatePeriodSeconds = updatePeriodSeconds;
    }

    /**
     * the time to wait between polling deployment status after update
     * 
     * @return
     *     The intervalSeconds
     */
    @JsonProperty("intervalSeconds")
    public Long getIntervalSeconds() {
        return intervalSeconds;
    }

    /**
     * the time to wait between polling deployment status after update
     * 
     * @param intervalSeconds
     *     The intervalSeconds
     */
    @JsonProperty("intervalSeconds")
    public void setIntervalSeconds(Long intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    /**
     * 
     * 
     * @return
     *     The post
     */
    @JsonProperty("post")
    public LifecycleHook getPost() {
        return post;
    }

    /**
     * 
     * 
     * @param post
     *     The post
     */
    @JsonProperty("post")
    public void setPost(LifecycleHook post) {
        this.post = post;
    }

    /**
     * 
     * 
     * @return
     *     The pre
     */
    @JsonProperty("pre")
    public LifecycleHook getPre() {
        return pre;
    }

    /**
     * 
     * 
     * @param pre
     *     The pre
     */
    @JsonProperty("pre")
    public void setPre(LifecycleHook pre) {
        this.pre = pre;
    }

    /**
     * the time to wait for updates before giving up
     * 
     * @return
     *     The timeoutSeconds
     */
    @JsonProperty("timeoutSeconds")
    public Long getTimeoutSeconds() {
        return timeoutSeconds;
    }

    /**
     * the time to wait for updates before giving up
     * 
     * @param timeoutSeconds
     *     The timeoutSeconds
     */
    @JsonProperty("timeoutSeconds")
    public void setTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    /**
     * the time to wait between individual pod updates
     * 
     * @return
     *     The updatePeriodSeconds
     */
    @JsonProperty("updatePeriodSeconds")
    public Long getUpdatePeriodSeconds() {
        return updatePeriodSeconds;
    }

    /**
     * the time to wait between individual pod updates
     * 
     * @param updatePeriodSeconds
     *     The updatePeriodSeconds
     */
    @JsonProperty("updatePeriodSeconds")
    public void setUpdatePeriodSeconds(Long updatePeriodSeconds) {
        this.updatePeriodSeconds = updatePeriodSeconds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(intervalSeconds).append(post).append(pre).append(timeoutSeconds).append(updatePeriodSeconds).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof RollingDeploymentStrategyParams) == false) {
            return false;
        }
        RollingDeploymentStrategyParams rhs = ((RollingDeploymentStrategyParams) other);
        return new EqualsBuilder().append(intervalSeconds, rhs.intervalSeconds).append(post, rhs.post).append(pre, rhs.pre).append(timeoutSeconds, rhs.timeoutSeconds).append(updatePeriodSeconds, rhs.updatePeriodSeconds).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
