
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "contextDir",
    "git",
    "sourceSecret",
    "type"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class BuildSource {

    /**
     * specifies sub-directory where the source code for the application exists
     * 
     */
    @JsonProperty("contextDir")
    private String contextDir;
    /**
     * 
     * 
     */
    @JsonProperty("git")
    @Valid
    private GitBuildSource git;
    /**
     * 
     * 
     */
    @JsonProperty("sourceSecret")
    @Valid
    private LocalObjectReference sourceSecret;
    /**
     * type of source control management system
     * 
     */
    @JsonProperty("type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BuildSource() {
    }

    /**
     * 
     * @param git
     * @param sourceSecret
     * @param contextDir
     * @param type
     */
    public BuildSource(String contextDir, GitBuildSource git, LocalObjectReference sourceSecret, String type) {
        this.contextDir = contextDir;
        this.git = git;
        this.sourceSecret = sourceSecret;
        this.type = type;
    }

    /**
     * specifies sub-directory where the source code for the application exists
     * 
     * @return
     *     The contextDir
     */
    @JsonProperty("contextDir")
    public String getContextDir() {
        return contextDir;
    }

    /**
     * specifies sub-directory where the source code for the application exists
     * 
     * @param contextDir
     *     The contextDir
     */
    @JsonProperty("contextDir")
    public void setContextDir(String contextDir) {
        this.contextDir = contextDir;
    }

    /**
     * 
     * 
     * @return
     *     The git
     */
    @JsonProperty("git")
    public GitBuildSource getGit() {
        return git;
    }

    /**
     * 
     * 
     * @param git
     *     The git
     */
    @JsonProperty("git")
    public void setGit(GitBuildSource git) {
        this.git = git;
    }

    /**
     * 
     * 
     * @return
     *     The sourceSecret
     */
    @JsonProperty("sourceSecret")
    public LocalObjectReference getSourceSecret() {
        return sourceSecret;
    }

    /**
     * 
     * 
     * @param sourceSecret
     *     The sourceSecret
     */
    @JsonProperty("sourceSecret")
    public void setSourceSecret(LocalObjectReference sourceSecret) {
        this.sourceSecret = sourceSecret;
    }

    /**
     * type of source control management system
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * type of source control management system
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(contextDir).append(git).append(sourceSecret).append(type).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof BuildSource) == false) {
            return false;
        }
        BuildSource rhs = ((BuildSource) other);
        return new EqualsBuilder().append(contextDir, rhs.contextDir).append(git, rhs.git).append(sourceSecret, rhs.sourceSecret).append(type, rhs.type).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
