package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ResourceQuotaListFluent<T extends ResourceQuotaListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     ResourceQuotaList.ApiVersion apiVersion;     List<VisitableBuilder<ResourceQuota, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public ResourceQuotaList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( ResourceQuotaList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( ResourceQuota item){
    if (item != null) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.items.add(builder);} return (T)this;
    }
    public List<ResourceQuota> getItems(){
    return build(items);
    }
    public T withItems( List<ResourceQuota> items){
    this.items.clear();if (items != null) {for (ResourceQuota item : items){this.addToItems(item);}} return (T) this;
    }
    public ItemsNested<T> addNewItem(){
    return new ItemsNested<T>();
    }
    public ItemsNested<T> addNewItemLike( ResourceQuota item){
    return new ItemsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class ItemsNested<N> extends ResourceQuotaFluent<ItemsNested<N>> implements Nested<N>{

        private final ResourceQuotaBuilder builder;
    
             ItemsNested (){
        this.builder = new ResourceQuotaBuilder(this);
        }
             ItemsNested ( ResourceQuota item){
        this.builder = new ResourceQuotaBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) ResourceQuotaListFluent.this.addToItems(builder.build());
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
    
            public N and(){
            return (N) ResourceQuotaListFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
