package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.Template;
import java.util.Map;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.kubernetes.api.root.RootPaths;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.RouteList;
import java.util.HashMap;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class KubeSchemaBuilder extends KubeSchemaFluent<KubeSchemaBuilder> implements VisitableBuilder<KubeSchema,KubeSchemaBuilder>{

     KubeSchemaFluent<?> fluent;
public KubeSchemaBuilder(){
    this(new KubeSchema());
}
public KubeSchemaBuilder( KubeSchemaFluent<?> fluent ){
    this(fluent, new KubeSchema());
}
public KubeSchemaBuilder( KubeSchemaFluent<?> fluent , KubeSchema instance ){
    this.fluent = fluent; fluent.withBaseKubernetesList(instance.getBaseKubernetesList()); fluent.withBuildConfigList(instance.getBuildConfigList()); fluent.withBuildList(instance.getBuildList()); fluent.withBuildRequest(instance.getBuildRequest()); fluent.withConfig(instance.getConfig()); fluent.withContainerStatus(instance.getContainerStatus()); fluent.withDeploymentConfigList(instance.getDeploymentConfigList()); fluent.withEndpoints(instance.getEndpoints()); fluent.withEndpointsList(instance.getEndpointsList()); fluent.withEnvVar(instance.getEnvVar()); fluent.withEventList(instance.getEventList()); fluent.withImageList(instance.getImageList()); fluent.withImageStreamList(instance.getImageStreamList()); fluent.withNamespace(instance.getNamespace()); fluent.withNamespaceList(instance.getNamespaceList()); fluent.withNode(instance.getNode()); fluent.withNodeList(instance.getNodeList()); fluent.withOAuthAccessToken(instance.getOAuthAccessToken()); fluent.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); fluent.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); fluent.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); fluent.withOAuthClient(instance.getOAuthClient()); fluent.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); fluent.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); fluent.withOAuthClientList(instance.getOAuthClientList()); fluent.withObjectMeta(instance.getObjectMeta()); fluent.withPersistentVolume(instance.getPersistentVolume()); fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); fluent.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); fluent.withPersistentVolumeList(instance.getPersistentVolumeList()); fluent.withPodList(instance.getPodList()); fluent.withQuantity(instance.getQuantity()); fluent.withReplicationControllerList(instance.getReplicationControllerList()); fluent.withResourceQuota(instance.getResourceQuota()); fluent.withResourceQuotaList(instance.getResourceQuotaList()); fluent.withRootPaths(instance.getRootPaths()); fluent.withRouteList(instance.getRouteList()); fluent.withSecret(instance.getSecret()); fluent.withSecretList(instance.getSecretList()); fluent.withServiceAccount(instance.getServiceAccount()); fluent.withServiceAccountList(instance.getServiceAccountList()); fluent.withServiceList(instance.getServiceList()); fluent.withStatus(instance.getStatus()); fluent.withTagEvent(instance.getTagEvent()); fluent.withTemplate(instance.getTemplate()); fluent.withTemplateList(instance.getTemplateList()); fluent.withWatchEvent(instance.getWatchEvent()); 
}
public KubeSchemaBuilder( KubeSchema instance ){
    this.fluent = this; this.withBaseKubernetesList(instance.getBaseKubernetesList()); this.withBuildConfigList(instance.getBuildConfigList()); this.withBuildList(instance.getBuildList()); this.withBuildRequest(instance.getBuildRequest()); this.withConfig(instance.getConfig()); this.withContainerStatus(instance.getContainerStatus()); this.withDeploymentConfigList(instance.getDeploymentConfigList()); this.withEndpoints(instance.getEndpoints()); this.withEndpointsList(instance.getEndpointsList()); this.withEnvVar(instance.getEnvVar()); this.withEventList(instance.getEventList()); this.withImageList(instance.getImageList()); this.withImageStreamList(instance.getImageStreamList()); this.withNamespace(instance.getNamespace()); this.withNamespaceList(instance.getNamespaceList()); this.withNode(instance.getNode()); this.withNodeList(instance.getNodeList()); this.withOAuthAccessToken(instance.getOAuthAccessToken()); this.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); this.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); this.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); this.withOAuthClient(instance.getOAuthClient()); this.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); this.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); this.withOAuthClientList(instance.getOAuthClientList()); this.withObjectMeta(instance.getObjectMeta()); this.withPersistentVolume(instance.getPersistentVolume()); this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); this.withPersistentVolumeList(instance.getPersistentVolumeList()); this.withPodList(instance.getPodList()); this.withQuantity(instance.getQuantity()); this.withReplicationControllerList(instance.getReplicationControllerList()); this.withResourceQuota(instance.getResourceQuota()); this.withResourceQuotaList(instance.getResourceQuotaList()); this.withRootPaths(instance.getRootPaths()); this.withRouteList(instance.getRouteList()); this.withSecret(instance.getSecret()); this.withSecretList(instance.getSecretList()); this.withServiceAccount(instance.getServiceAccount()); this.withServiceAccountList(instance.getServiceAccountList()); this.withServiceList(instance.getServiceList()); this.withStatus(instance.getStatus()); this.withTagEvent(instance.getTagEvent()); this.withTemplate(instance.getTemplate()); this.withTemplateList(instance.getTemplateList()); this.withWatchEvent(instance.getWatchEvent()); 
}

public EditableKubeSchema build(){
    EditableKubeSchema buildable = new EditableKubeSchema(fluent.getBaseKubernetesList(),fluent.getBuildConfigList(),fluent.getBuildList(),fluent.getBuildRequest(),fluent.getConfig(),fluent.getContainerStatus(),fluent.getDeploymentConfigList(),fluent.getEndpoints(),fluent.getEndpointsList(),fluent.getEnvVar(),fluent.getEventList(),fluent.getImageList(),fluent.getImageStreamList(),fluent.getNamespace(),fluent.getNamespaceList(),fluent.getNode(),fluent.getNodeList(),fluent.getOAuthAccessToken(),fluent.getOAuthAccessTokenList(),fluent.getOAuthAuthorizeToken(),fluent.getOAuthAuthorizeTokenList(),fluent.getOAuthClient(),fluent.getOAuthClientAuthorization(),fluent.getOAuthClientAuthorizationList(),fluent.getOAuthClientList(),fluent.getObjectMeta(),fluent.getPersistentVolume(),fluent.getPersistentVolumeClaim(),fluent.getPersistentVolumeClaimList(),fluent.getPersistentVolumeList(),fluent.getPodList(),fluent.getQuantity(),fluent.getReplicationControllerList(),fluent.getResourceQuota(),fluent.getResourceQuotaList(),fluent.getRootPaths(),fluent.getRouteList(),fluent.getSecret(),fluent.getSecretList(),fluent.getServiceAccount(),fluent.getServiceAccountList(),fluent.getServiceList(),fluent.getStatus(),fluent.getTagEvent(),fluent.getTemplate(),fluent.getTemplateList(),fluent.getWatchEvent());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    