package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ListMetaBuilder extends ListMetaFluent<ListMetaBuilder> implements VisitableBuilder<ListMeta,ListMetaBuilder>{

     ListMetaFluent<?> fluent;
public ListMetaBuilder(){
    this(new ListMeta());
}
public ListMetaBuilder( ListMetaFluent<?> fluent ){
    this(fluent, new ListMeta());
}
public ListMetaBuilder( ListMetaFluent<?> fluent , ListMeta instance ){
    this.fluent = fluent; fluent.withResourceVersion(instance.getResourceVersion()); fluent.withSelfLink(instance.getSelfLink()); 
}
public ListMetaBuilder( ListMeta instance ){
    this.fluent = this; this.withResourceVersion(instance.getResourceVersion()); this.withSelfLink(instance.getSelfLink()); 
}

public EditableListMeta build(){
    EditableListMeta buildable = new EditableListMeta(fluent.getResourceVersion(),fluent.getSelfLink());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    