/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeSpec;
import io.fabric8.kubernetes.api.model.NodeSpecBuilder;
import io.fabric8.kubernetes.api.model.NodeSpecFluent;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusBuilder;
import io.fabric8.kubernetes.api.model.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.util.HashMap;
import java.util.Map;

public class NodeFluent<T extends NodeFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Node.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<NodeSpec, ?> spec;
    VisitableBuilder<NodeStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Node.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Node.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public NodeSpec getSpec() {
        return this.spec != null ? (NodeSpec)this.spec.build() : null;
    }

    public T withSpec(NodeSpec spec) {
        if (spec != null) {
            this.spec = new NodeSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public SpecNested<T> withNewSpecLike(NodeSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    public T withNewSpec(String externalID, String podCIDR, Boolean unschedulable) {
        return this.withSpec(new NodeSpec(externalID, podCIDR, unschedulable));
    }

    public NodeStatus getStatus() {
        return this.status != null ? (NodeStatus)this.status.build() : null;
    }

    public T withStatus(NodeStatus status) {
        if (status != null) {
            this.status = new NodeStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    public StatusNested<T> withNewStatus() {
        return new StatusNested();
    }

    public StatusNested<T> withNewStatusLike(NodeStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class StatusNested<N>
    extends NodeStatusFluent<StatusNested<N>>
    implements Nested<N> {
        private final NodeStatusBuilder builder;

        StatusNested(NodeStatus item) {
            this.builder = new NodeStatusBuilder(this, item);
        }

        StatusNested() {
            this.builder = new NodeStatusBuilder(this);
        }

        public N endStatus() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeFluent.this.withStatus(this.builder.build());
        }
    }

    public class SpecNested<N>
    extends NodeSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final NodeSpecBuilder builder;

        SpecNested() {
            this.builder = new NodeSpecBuilder(this);
        }

        SpecNested(NodeSpec item) {
            this.builder = new NodeSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NodeFluent.this.withMetadata(this.builder.build());
        }
    }
}

