package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public class OAuthClientFluent<T extends OAuthClientFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     OAuthClient.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<String> redirectURIs = new ArrayList();     Boolean respondWithChallenges;     String secret;     Map<String, Object> additionalProperties = new HashMap();

    public OAuthClient.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( OAuthClient.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToRedirectURIs( String item){
    if (item != null) {this.redirectURIs.add(item);} return (T)this;
    }
    public List<String> getRedirectURIs(){
    return this.redirectURIs;
    }
    public T withRedirectURIs( List<String> redirectURIs){
    this.redirectURIs.clear();if (redirectURIs != null) {for (String item : redirectURIs){this.addToRedirectURIs(item);}} return (T) this;
    }
    public Boolean isRespondWithChallenges(){
    return this.respondWithChallenges;
    }
    public T withRespondWithChallenges( Boolean respondWithChallenges){
    this.respondWithChallenges=respondWithChallenges; return (T) this;
    }
    public String getSecret(){
    return this.secret;
    }
    public T withSecret( String secret){
    this.secret=secret; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) OAuthClientFluent.this.withMetadata(builder.build());
        }
    
}


}
