package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectReference;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class NamedTagReferenceFluent<T extends NamedTagReferenceFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Map<String, String> annotations = new HashMap();     VisitableBuilder<ObjectReference, ?> from;     String name;     Map<String, Object> additionalProperties = new HashMap();

    public T addToAnnotations( String key,  String value){
    if(key != null && value != null) {this.annotations.put(key, value);} return (T)this;
    }
    public Map<String, String> getAnnotations(){
    return this.annotations;
    }
    public T withAnnotations( Map<String, String> annotations){
    this.annotations.clear();if (annotations != null) {this.annotations.putAll(annotations);} return (T) this;
    }
    public ObjectReference getFrom(){
    return this.from!=null?this.from.build():null;
    }
    public T withFrom( ObjectReference from){
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.add(this.from);} return (T) this;
    }
    public FromNested<T> withNewFrom(){
    return new FromNested<T>();
    }
    public FromNested<T> withNewFromLike( ObjectReference item){
    return new FromNested<T>(item);
    }
    public FromNested<T> editFrom(){
    return withNewFromLike(getFrom());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class FromNested<N> extends ObjectReferenceFluent<FromNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             FromNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
             FromNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
    
            public N endFrom(){
            return and();
        }
            public N and(){
            return (N) NamedTagReferenceFluent.this.withFrom(builder.build());
        }
    
}


}
