
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "capabilities",
    "privileged",
    "runAsUser",
    "seLinuxOptions"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class SecurityContext {

    /**
     * 
     * 
     */
    @JsonProperty("capabilities")
    @Valid
    private Capabilities capabilities;
    /**
     * run the container in privileged mode
     * 
     */
    @JsonProperty("privileged")
    private Boolean privileged;
    /**
     * the user id that runs the first process in the container
     * 
     */
    @JsonProperty("runAsUser")
    private Long runAsUser;
    /**
     * 
     * 
     */
    @JsonProperty("seLinuxOptions")
    @Valid
    private SELinuxOptions seLinuxOptions;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public SecurityContext() {
    }

    /**
     * 
     * @param seLinuxOptions
     * @param privileged
     * @param capabilities
     * @param runAsUser
     */
    public SecurityContext(Capabilities capabilities, Boolean privileged, Long runAsUser, SELinuxOptions seLinuxOptions) {
        this.capabilities = capabilities;
        this.privileged = privileged;
        this.runAsUser = runAsUser;
        this.seLinuxOptions = seLinuxOptions;
    }

    /**
     * 
     * 
     * @return
     *     The capabilities
     */
    @JsonProperty("capabilities")
    public Capabilities getCapabilities() {
        return capabilities;
    }

    /**
     * 
     * 
     * @param capabilities
     *     The capabilities
     */
    @JsonProperty("capabilities")
    public void setCapabilities(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    /**
     * run the container in privileged mode
     * 
     * @return
     *     The privileged
     */
    @JsonProperty("privileged")
    public Boolean getPrivileged() {
        return privileged;
    }

    /**
     * run the container in privileged mode
     * 
     * @param privileged
     *     The privileged
     */
    @JsonProperty("privileged")
    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    /**
     * the user id that runs the first process in the container
     * 
     * @return
     *     The runAsUser
     */
    @JsonProperty("runAsUser")
    public Long getRunAsUser() {
        return runAsUser;
    }

    /**
     * the user id that runs the first process in the container
     * 
     * @param runAsUser
     *     The runAsUser
     */
    @JsonProperty("runAsUser")
    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    /**
     * 
     * 
     * @return
     *     The seLinuxOptions
     */
    @JsonProperty("seLinuxOptions")
    public SELinuxOptions getSeLinuxOptions() {
        return seLinuxOptions;
    }

    /**
     * 
     * 
     * @param seLinuxOptions
     *     The seLinuxOptions
     */
    @JsonProperty("seLinuxOptions")
    public void setSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(capabilities).append(privileged).append(runAsUser).append(seLinuxOptions).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof SecurityContext) == false) {
            return false;
        }
        SecurityContext rhs = ((SecurityContext) other);
        return new EqualsBuilder().append(capabilities, rhs.capabilities).append(privileged, rhs.privileged).append(runAsUser, rhs.runAsUser).append(seLinuxOptions, rhs.seLinuxOptions).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
