package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ReplicationControllerSpecFluent<T extends ReplicationControllerSpecFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Integer replicas;     Map<String, String> selector = new HashMap();     VisitableBuilder<PodTemplateSpec, ?> template;     VisitableBuilder<ObjectReference, ?> templateRef;     Map<String, Object> additionalProperties = new HashMap();

    public Integer getReplicas(){
    return this.replicas;
    }
    public T withReplicas( Integer replicas){
    this.replicas=replicas; return (T) this;
    }
    public T addToSelector( String key,  String value){
    if(key != null && value != null) {this.selector.put(key, value);} return (T)this;
    }
    public Map<String, String> getSelector(){
    return this.selector;
    }
    public T withSelector( Map<String, String> selector){
    this.selector.clear();if (selector != null) {this.selector.putAll(selector);} return (T) this;
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public T withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (T) this;
    }
    public TemplateNested<T> withNewTemplate(){
    return new TemplateNested<T>();
    }
    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNested<T>(item);
    }
    public TemplateNested<T> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public ObjectReference getTemplateRef(){
    return this.templateRef!=null?this.templateRef.build():null;
    }
    public T withTemplateRef( ObjectReference templateRef){
    if (templateRef!=null){ this.templateRef= new ObjectReferenceBuilder(templateRef); _visitables.add(this.templateRef);} return (T) this;
    }
    public TemplateRefNested<T> withNewTemplateRef(){
    return new TemplateRefNested<T>();
    }
    public TemplateRefNested<T> withNewTemplateRefLike( ObjectReference item){
    return new TemplateRefNested<T>(item);
    }
    public TemplateRefNested<T> editTemplateRef(){
    return withNewTemplateRefLike(getTemplateRef());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class TemplateNested<N> extends PodTemplateSpecFluent<TemplateNested<N>> implements Nested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNested (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNested ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N and(){
            return (N) ReplicationControllerSpecFluent.this.withTemplate(builder.build());
        }
            public N endTemplate(){
            return and();
        }
    
}
    public class TemplateRefNested<N> extends ObjectReferenceFluent<TemplateRefNested<N>> implements Nested<N>{

        private final ObjectReferenceBuilder builder;
    
             TemplateRefNested (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             TemplateRefNested ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) ReplicationControllerSpecFluent.this.withTemplateRef(builder.build());
        }
            public N endTemplateRef(){
            return and();
        }
    
}


}
