
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "fsType",
    "partition",
    "readOnly",
    "volumeID"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class AWSElasticBlockStoreVolumeSource {

    /**
     * file system type to mount
     * 
     */
    @JsonProperty("fsType")
    private String fsType;
    /**
     * partition on the disk to mount (e.g.
     * 
     */
    @JsonProperty("partition")
    private Integer partition;
    /**
     * read-only if true
     * 
     */
    @JsonProperty("readOnly")
    private Boolean readOnly;
    /**
     * unique id of the PD resource in AWS
     * 
     */
    @JsonProperty("volumeID")
    private String volumeID;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public AWSElasticBlockStoreVolumeSource() {
    }

    /**
     * 
     * @param fsType
     * @param volumeID
     * @param readOnly
     * @param partition
     */
    public AWSElasticBlockStoreVolumeSource(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        this.fsType = fsType;
        this.partition = partition;
        this.readOnly = readOnly;
        this.volumeID = volumeID;
    }

    /**
     * file system type to mount
     * 
     * @return
     *     The fsType
     */
    @JsonProperty("fsType")
    public String getFsType() {
        return fsType;
    }

    /**
     * file system type to mount
     * 
     * @param fsType
     *     The fsType
     */
    @JsonProperty("fsType")
    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    /**
     * partition on the disk to mount (e.g.
     * 
     * @return
     *     The partition
     */
    @JsonProperty("partition")
    public Integer getPartition() {
        return partition;
    }

    /**
     * partition on the disk to mount (e.g.
     * 
     * @param partition
     *     The partition
     */
    @JsonProperty("partition")
    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    /**
     * read-only if true
     * 
     * @return
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public Boolean getReadOnly() {
        return readOnly;
    }

    /**
     * read-only if true
     * 
     * @param readOnly
     *     The readOnly
     */
    @JsonProperty("readOnly")
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    /**
     * unique id of the PD resource in AWS
     * 
     * @return
     *     The volumeID
     */
    @JsonProperty("volumeID")
    public String getVolumeID() {
        return volumeID;
    }

    /**
     * unique id of the PD resource in AWS
     * 
     * @param volumeID
     *     The volumeID
     */
    @JsonProperty("volumeID")
    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(fsType).append(partition).append(readOnly).append(volumeID).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AWSElasticBlockStoreVolumeSource) == false) {
            return false;
        }
        AWSElasticBlockStoreVolumeSource rhs = ((AWSElasticBlockStoreVolumeSource) other);
        return new EqualsBuilder().append(fsType, rhs.fsType).append(partition, rhs.partition).append(readOnly, rhs.readOnly).append(volumeID, rhs.volumeID).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
