package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class PodFluent<T extends PodFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     Pod.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<PodSpec, ?> spec;     VisitableBuilder<PodStatus, ?> status;     Map<String, Object> additionalProperties = new HashMap();

    public Pod.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( Pod.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public PodSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public T withSpec( PodSpec spec){
    if (spec!=null){ this.spec= new PodSpecBuilder(spec); _visitables.add(this.spec);} return (T) this;
    }
    public SpecNested<T> withNewSpec(){
    return new SpecNested<T>();
    }
    public SpecNested<T> withNewSpecLike( PodSpec item){
    return new SpecNested<T>(item);
    }
    public SpecNested<T> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public PodStatus getStatus(){
    return this.status!=null?this.status.build():null;
    }
    public T withStatus( PodStatus status){
    if (status!=null){ this.status= new PodStatusBuilder(status); _visitables.add(this.status);} return (T) this;
    }
    public StatusNested<T> withNewStatus(){
    return new StatusNested<T>();
    }
    public StatusNested<T> withNewStatusLike( PodStatus item){
    return new StatusNested<T>(item);
    }
    public StatusNested<T> editStatus(){
    return withNewStatusLike(getStatus());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) PodFluent.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNested<N> extends PodSpecFluent<SpecNested<N>> implements Nested<N>{

        private final PodSpecBuilder builder;
    
             SpecNested (){
        this.builder = new PodSpecBuilder(this);
        }
             SpecNested ( PodSpec item){
        this.builder = new PodSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) PodFluent.this.withSpec(builder.build());
        }
    
}
    public class StatusNested<N> extends PodStatusFluent<StatusNested<N>> implements Nested<N>{

        private final PodStatusBuilder builder;
    
             StatusNested (){
        this.builder = new PodStatusBuilder(this);
        }
             StatusNested ( PodStatus item){
        this.builder = new PodStatusBuilder(this, item);
        }
    
            public N endStatus(){
            return and();
        }
            public N and(){
            return (N) PodFluent.this.withStatus(builder.build());
        }
    
}


}
