package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class NodeStatusFluent<T extends NodeStatusFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     List<VisitableBuilder<NodeAddress, ?>> addresses = new ArrayList();     Map<String, Quantity> capacity = new HashMap();     List<VisitableBuilder<NodeCondition, ?>> conditions = new ArrayList();     VisitableBuilder<NodeSystemInfo, ?> nodeInfo;     String phase;     Map<String, Object> additionalProperties = new HashMap();

    public T addToAddresses( NodeAddress item){
    if (item != null) {NodeAddressBuilder builder = new NodeAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (T)this;
    }
    public List<NodeAddress> getAddresses(){
    return build(addresses);
    }
    public T withAddresses( List<NodeAddress> addresses){
    this.addresses.clear();if (addresses != null) {for (NodeAddress item : addresses){this.addToAddresses(item);}} return (T) this;
    }
    public AddressesNested<T> addNewAddresse(){
    return new AddressesNested<T>();
    }
    public AddressesNested<T> addNewAddresseLike( NodeAddress item){
    return new AddressesNested<T>(item);
    }
    public T addNewAddresse( String address,  String type){
    return addToAddresses(new NodeAddress(address, type));
    }
    public T addToCapacity( String key,  Quantity value){
    if(key != null && value != null) {this.capacity.put(key, value);} return (T)this;
    }
    public Map<String, Quantity> getCapacity(){
    return this.capacity;
    }
    public T withCapacity( Map<String, Quantity> capacity){
    this.capacity.clear();if (capacity != null) {this.capacity.putAll(capacity);} return (T) this;
    }
    public T addToConditions( NodeCondition item){
    if (item != null) {NodeConditionBuilder builder = new NodeConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (T)this;
    }
    public List<NodeCondition> getConditions(){
    return build(conditions);
    }
    public T withConditions( List<NodeCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (NodeCondition item : conditions){this.addToConditions(item);}} return (T) this;
    }
    public ConditionsNested<T> addNewCondition(){
    return new ConditionsNested<T>();
    }
    public ConditionsNested<T> addNewConditionLike( NodeCondition item){
    return new ConditionsNested<T>(item);
    }
    public NodeSystemInfo getNodeInfo(){
    return this.nodeInfo!=null?this.nodeInfo.build():null;
    }
    public T withNodeInfo( NodeSystemInfo nodeInfo){
    if (nodeInfo!=null){ this.nodeInfo= new NodeSystemInfoBuilder(nodeInfo); _visitables.add(this.nodeInfo);} return (T) this;
    }
    public NodeInfoNested<T> withNewNodeInfo(){
    return new NodeInfoNested<T>();
    }
    public NodeInfoNested<T> withNewNodeInfoLike( NodeSystemInfo item){
    return new NodeInfoNested<T>(item);
    }
    public NodeInfoNested<T> editNodeInfo(){
    return withNewNodeInfoLike(getNodeInfo());
    }
    public String getPhase(){
    return this.phase;
    }
    public T withPhase( String phase){
    this.phase=phase; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class AddressesNested<N> extends NodeAddressFluent<AddressesNested<N>> implements Nested<N>{

        private final NodeAddressBuilder builder;
    
             AddressesNested ( NodeAddress item){
        this.builder = new NodeAddressBuilder(this, item);
        }
             AddressesNested (){
        this.builder = new NodeAddressBuilder(this);
        }
    
            public N and(){
            return (N) NodeStatusFluent.this.addToAddresses(builder.build());
        }
            public N endAddresse(){
            return and();
        }
    
}
    public class ConditionsNested<N> extends NodeConditionFluent<ConditionsNested<N>> implements Nested<N>{

        private final NodeConditionBuilder builder;
    
             ConditionsNested ( NodeCondition item){
        this.builder = new NodeConditionBuilder(this, item);
        }
             ConditionsNested (){
        this.builder = new NodeConditionBuilder(this);
        }
    
            public N and(){
            return (N) NodeStatusFluent.this.addToConditions(builder.build());
        }
            public N endCondition(){
            return and();
        }
    
}
    public class NodeInfoNested<N> extends NodeSystemInfoFluent<NodeInfoNested<N>> implements Nested<N>{

        private final NodeSystemInfoBuilder builder;
    
             NodeInfoNested ( NodeSystemInfo item){
        this.builder = new NodeSystemInfoBuilder(this, item);
        }
             NodeInfoNested (){
        this.builder = new NodeSystemInfoBuilder(this);
        }
    
            public N endNodeInfo(){
            return and();
        }
            public N and(){
            return (N) NodeStatusFluent.this.withNodeInfo(builder.build());
        }
    
}


}
