package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class NodeAddressBuilder extends NodeAddressFluent<NodeAddressBuilder> implements VisitableBuilder<NodeAddress,NodeAddressBuilder>{

     NodeAddressFluent<?> fluent;
public NodeAddressBuilder(){
    this(new NodeAddress());
}
public NodeAddressBuilder( NodeAddressFluent<?> fluent ){
    this(fluent, new NodeAddress());
}
public NodeAddressBuilder( NodeAddressFluent<?> fluent , NodeAddress instance ){
    this.fluent = fluent; fluent.withAddress(instance.getAddress()); fluent.withType(instance.getType()); 
}
public NodeAddressBuilder( NodeAddress instance ){
    this.fluent = this; this.withAddress(instance.getAddress()); this.withType(instance.getType()); 
}

public EditableNodeAddress build(){
    EditableNodeAddress buildable = new EditableNodeAddress(fluent.getAddress(),fluent.getType());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    