package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ContainerStateBuilder extends ContainerStateFluent<ContainerStateBuilder> implements VisitableBuilder<ContainerState,ContainerStateBuilder>{

     ContainerStateFluent<?> fluent;
public ContainerStateBuilder(){
    this(new ContainerState());
}
public ContainerStateBuilder( ContainerStateFluent<?> fluent ){
    this(fluent, new ContainerState());
}
public ContainerStateBuilder( ContainerStateFluent<?> fluent , ContainerState instance ){
    this.fluent = fluent; fluent.withRunning(instance.getRunning()); fluent.withTermination(instance.getTermination()); fluent.withWaiting(instance.getWaiting()); 
}
public ContainerStateBuilder( ContainerState instance ){
    this.fluent = this; this.withRunning(instance.getRunning()); this.withTermination(instance.getTermination()); this.withWaiting(instance.getWaiting()); 
}

public EditableContainerState build(){
    EditableContainerState buildable = new EditableContainerState(fluent.getRunning(),fluent.getTermination(),fluent.getWaiting());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    