/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddress;
import io.fabric8.kubernetes.api.model.EndpointAddressBuilder;
import io.fabric8.kubernetes.api.model.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.EndpointPort;
import io.fabric8.kubernetes.api.model.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.EndpointPortFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EndpointSubsetFluent<T extends EndpointSubsetFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    List<VisitableBuilder<EndpointAddress, ?>> addresses = new ArrayList();
    List<VisitableBuilder<EndpointPort, ?>> ports = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public T addToAddresses(EndpointAddress item) {
        if (item != null) {
            EndpointAddressBuilder builder = new EndpointAddressBuilder(item);
            this._visitables.add(builder);
            this.addresses.add(builder);
        }
        return (T)this;
    }

    public List<EndpointAddress> getAddresses() {
        return this.build(this.addresses);
    }

    public T withAddresses(List<EndpointAddress> addresses) {
        this.addresses.clear();
        if (addresses != null) {
            for (EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (T)this;
    }

    public AddressesNested<T> addNewAddresse() {
        return new AddressesNested();
    }

    public AddressesNested<T> addNewAddresseLike(EndpointAddress item) {
        return new AddressesNested(item);
    }

    public T addToPorts(EndpointPort item) {
        if (item != null) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)this;
    }

    public List<EndpointPort> getPorts() {
        return this.build(this.ports);
    }

    public T withPorts(List<EndpointPort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    public PortsNested<T> addNewPort() {
        return new PortsNested();
    }

    public PortsNested<T> addNewPortLike(EndpointPort item) {
        return new PortsNested(item);
    }

    public T addNewPort(String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(name, port, protocol));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public class PortsNested<N>
    extends EndpointPortFluent<PortsNested<N>>
    implements Nested<N> {
        private final EndpointPortBuilder builder;

        PortsNested() {
            this.builder = new EndpointPortBuilder(this);
        }

        PortsNested(EndpointPort item) {
            this.builder = new EndpointPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluent.this.addToPorts(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends EndpointAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        private final EndpointAddressBuilder builder;

        AddressesNested(EndpointAddress item) {
            this.builder = new EndpointAddressBuilder(this, item);
        }

        AddressesNested() {
            this.builder = new EndpointAddressBuilder(this);
        }

        public N endAddresse() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)EndpointSubsetFluent.this.addToAddresses(this.builder.build());
        }
    }
}

