
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "dockerImageManifest",
    "dockerImageMetadata",
    "dockerImageMetadataVersion",
    "dockerImageReference",
    "kind",
    "metadata"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class Image implements io.fabric8.kubernetes.api.model.HasMetadata
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("apiVersion")
    @NotNull
    private Image.ApiVersion apiVersion = Image.ApiVersion.fromValue("v1");
    /**
     * raw JSON of the manifest
     * 
     */
    @JsonProperty("dockerImageManifest")
    private String dockerImageManifest;
    /**
     * 
     * 
     */
    @JsonProperty("dockerImageMetadata")
    @Valid
    private io.fabric8.kubernetes.api.model.HasMetadata dockerImageMetadata;
    /**
     * conveys version of the object
     * 
     */
    @JsonProperty("dockerImageMetadataVersion")
    private String dockerImageMetadataVersion;
    /**
     * string that can be used to pull this image
     * 
     */
    @JsonProperty("dockerImageReference")
    private String dockerImageReference;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("kind")
    @NotNull
    private String kind = "Image";
    /**
     * 
     * 
     */
    @JsonProperty("metadata")
    @Valid
    private ObjectMeta metadata;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public Image() {
    }

    /**
     * 
     * @param dockerImageReference
     * @param apiVersion
     * @param dockerImageManifest
     * @param dockerImageMetadata
     * @param kind
     * @param dockerImageMetadataVersion
     * @param metadata
     */
    public Image(Image.ApiVersion apiVersion, String dockerImageManifest, io.fabric8.kubernetes.api.model.HasMetadata dockerImageMetadata, String dockerImageMetadataVersion, String dockerImageReference, String kind, ObjectMeta metadata) {
        this.apiVersion = apiVersion;
        this.dockerImageManifest = dockerImageManifest;
        this.dockerImageMetadata = dockerImageMetadata;
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
        this.dockerImageReference = dockerImageReference;
        this.kind = kind;
        this.metadata = metadata;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public Image.ApiVersion getApiVersion() {
        return apiVersion;
    }

    /**
     * 
     * (Required)
     * 
     * @param apiVersion
     *     The apiVersion
     */
    @JsonProperty("apiVersion")
    public void setApiVersion(Image.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    /**
     * raw JSON of the manifest
     * 
     * @return
     *     The dockerImageManifest
     */
    @JsonProperty("dockerImageManifest")
    public String getDockerImageManifest() {
        return dockerImageManifest;
    }

    /**
     * raw JSON of the manifest
     * 
     * @param dockerImageManifest
     *     The dockerImageManifest
     */
    @JsonProperty("dockerImageManifest")
    public void setDockerImageManifest(String dockerImageManifest) {
        this.dockerImageManifest = dockerImageManifest;
    }

    /**
     * 
     * 
     * @return
     *     The dockerImageMetadata
     */
    @JsonProperty("dockerImageMetadata")
    public io.fabric8.kubernetes.api.model.HasMetadata getDockerImageMetadata() {
        return dockerImageMetadata;
    }

    /**
     * 
     * 
     * @param dockerImageMetadata
     *     The dockerImageMetadata
     */
    @JsonProperty("dockerImageMetadata")
    public void setDockerImageMetadata(io.fabric8.kubernetes.api.model.HasMetadata dockerImageMetadata) {
        this.dockerImageMetadata = dockerImageMetadata;
    }

    /**
     * conveys version of the object
     * 
     * @return
     *     The dockerImageMetadataVersion
     */
    @JsonProperty("dockerImageMetadataVersion")
    public String getDockerImageMetadataVersion() {
        return dockerImageMetadataVersion;
    }

    /**
     * conveys version of the object
     * 
     * @param dockerImageMetadataVersion
     *     The dockerImageMetadataVersion
     */
    @JsonProperty("dockerImageMetadataVersion")
    public void setDockerImageMetadataVersion(String dockerImageMetadataVersion) {
        this.dockerImageMetadataVersion = dockerImageMetadataVersion;
    }

    /**
     * string that can be used to pull this image
     * 
     * @return
     *     The dockerImageReference
     */
    @JsonProperty("dockerImageReference")
    public String getDockerImageReference() {
        return dockerImageReference;
    }

    /**
     * string that can be used to pull this image
     * 
     * @param dockerImageReference
     *     The dockerImageReference
     */
    @JsonProperty("dockerImageReference")
    public void setDockerImageReference(String dockerImageReference) {
        this.dockerImageReference = dockerImageReference;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The kind
     */
    @JsonProperty("kind")
    public String getKind() {
        return kind;
    }

    /**
     * 
     * (Required)
     * 
     * @param kind
     *     The kind
     */
    @JsonProperty("kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    /**
     * 
     * 
     * @return
     *     The metadata
     */
    @JsonProperty("metadata")
    public ObjectMeta getMetadata() {
        return metadata;
    }

    /**
     * 
     * 
     * @param metadata
     *     The metadata
     */
    @JsonProperty("metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(apiVersion).append(dockerImageManifest).append(dockerImageMetadata).append(dockerImageMetadataVersion).append(dockerImageReference).append(kind).append(metadata).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Image) == false) {
            return false;
        }
        Image rhs = ((Image) other);
        return new EqualsBuilder().append(apiVersion, rhs.apiVersion).append(dockerImageManifest, rhs.dockerImageManifest).append(dockerImageMetadata, rhs.dockerImageMetadata).append(dockerImageMetadataVersion, rhs.dockerImageMetadataVersion).append(dockerImageReference, rhs.dockerImageReference).append(kind, rhs.kind).append(metadata, rhs.metadata).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

    @Generated("org.jsonschema2pojo")
    public static enum ApiVersion {

        V_1("v1");
        private final String value;
        private static Map<String, Image.ApiVersion> constants = new HashMap<String, Image.ApiVersion>();

        static {
            for (Image.ApiVersion c: values()) {
                constants.put(c.value, c);
            }
        }

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        @Override
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Image.ApiVersion fromValue(String value) {
            Image.ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
