package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class GitSourceRevisionFluent<T extends GitSourceRevisionFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<SourceControlUser, ?> author;     String commit;     VisitableBuilder<SourceControlUser, ?> committer;     String message;     Map<String, Object> additionalProperties = new HashMap();

    public SourceControlUser getAuthor(){
    return this.author!=null?this.author.build():null;
    }
    public T withAuthor( SourceControlUser author){
    if (author!=null){ this.author= new SourceControlUserBuilder(author); _visitables.add(this.author);} return (T) this;
    }
    public AuthorNested<T> withNewAuthor(){
    return new AuthorNested<T>();
    }
    public AuthorNested<T> withNewAuthorLike( SourceControlUser item){
    return new AuthorNested<T>(item);
    }
    public AuthorNested<T> editAuthor(){
    return withNewAuthorLike(getAuthor());
    }
    public T withNewAuthor( String email,  String name){
    return withAuthor(new SourceControlUser(email, name));
    }
    public String getCommit(){
    return this.commit;
    }
    public T withCommit( String commit){
    this.commit=commit; return (T) this;
    }
    public SourceControlUser getCommitter(){
    return this.committer!=null?this.committer.build():null;
    }
    public T withCommitter( SourceControlUser committer){
    if (committer!=null){ this.committer= new SourceControlUserBuilder(committer); _visitables.add(this.committer);} return (T) this;
    }
    public CommitterNested<T> withNewCommitter(){
    return new CommitterNested<T>();
    }
    public CommitterNested<T> withNewCommitterLike( SourceControlUser item){
    return new CommitterNested<T>(item);
    }
    public CommitterNested<T> editCommitter(){
    return withNewCommitterLike(getCommitter());
    }
    public T withNewCommitter( String email,  String name){
    return withCommitter(new SourceControlUser(email, name));
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class AuthorNested<N> extends SourceControlUserFluent<AuthorNested<N>> implements Nested<N>{

        private final SourceControlUserBuilder builder;
    
             AuthorNested (){
        this.builder = new SourceControlUserBuilder(this);
        }
             AuthorNested ( SourceControlUser item){
        this.builder = new SourceControlUserBuilder(this, item);
        }
    
            public N and(){
            return (N) GitSourceRevisionFluent.this.withAuthor(builder.build());
        }
            public N endAuthor(){
            return and();
        }
    
}
    public class CommitterNested<N> extends SourceControlUserFluent<CommitterNested<N>> implements Nested<N>{

        private final SourceControlUserBuilder builder;
    
             CommitterNested ( SourceControlUser item){
        this.builder = new SourceControlUserBuilder(this, item);
        }
             CommitterNested (){
        this.builder = new SourceControlUserBuilder(this);
        }
    
            public N and(){
            return (N) GitSourceRevisionFluent.this.withCommitter(builder.build());
        }
            public N endCommitter(){
            return and();
        }
    
}


}
