
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "field",
    "message",
    "reason"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class StatusCause {

    /**
     * field of the resource that has caused this error
     * 
     */
    @JsonProperty("field")
    private String field;
    /**
     * human-readable description of the cause of the error; this field may be presented as-is to a reader
     * 
     */
    @JsonProperty("message")
    private String message;
    /**
     * machine-readable description of the cause of the error; if this value is empty there is no information available
     * 
     */
    @JsonProperty("reason")
    private String reason;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public StatusCause() {
    }

    /**
     * 
     * @param message
     * @param field
     * @param reason
     */
    public StatusCause(String field, String message, String reason) {
        this.field = field;
        this.message = message;
        this.reason = reason;
    }

    /**
     * field of the resource that has caused this error
     * 
     * @return
     *     The field
     */
    @JsonProperty("field")
    public String getField() {
        return field;
    }

    /**
     * field of the resource that has caused this error
     * 
     * @param field
     *     The field
     */
    @JsonProperty("field")
    public void setField(String field) {
        this.field = field;
    }

    /**
     * human-readable description of the cause of the error; this field may be presented as-is to a reader
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * human-readable description of the cause of the error; this field may be presented as-is to a reader
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * machine-readable description of the cause of the error; if this value is empty there is no information available
     * 
     * @return
     *     The reason
     */
    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    /**
     * machine-readable description of the cause of the error; if this value is empty there is no information available
     * 
     * @param reason
     *     The reason
     */
    @JsonProperty("reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(field).append(message).append(reason).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof StatusCause) == false) {
            return false;
        }
        StatusCause rhs = ((StatusCause) other);
        return new EqualsBuilder().append(field, rhs.field).append(message, rhs.message).append(reason, rhs.reason).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
