
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "hard",
    "used"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class ResourceQuotaStatus {

    /**
     * hard is the set of enforced hard limits for each named resource
     * 
     */
    @JsonProperty("hard")
    @Valid
    private Map<String, io.fabric8.kubernetes.api.model.Quantity> hard;
    /**
     * used is the current observed total usage of the resource in the namespace
     * 
     */
    @JsonProperty("used")
    @Valid
    private Map<String, io.fabric8.kubernetes.api.model.Quantity> used;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ResourceQuotaStatus() {
    }

    /**
     * 
     * @param used
     * @param hard
     */
    public ResourceQuotaStatus(Map<String, io.fabric8.kubernetes.api.model.Quantity> hard, Map<String, io.fabric8.kubernetes.api.model.Quantity> used) {
        this.hard = hard;
        this.used = used;
    }

    /**
     * hard is the set of enforced hard limits for each named resource
     * 
     * @return
     *     The hard
     */
    @JsonProperty("hard")
    public Map<String, io.fabric8.kubernetes.api.model.Quantity> getHard() {
        return hard;
    }

    /**
     * hard is the set of enforced hard limits for each named resource
     * 
     * @param hard
     *     The hard
     */
    @JsonProperty("hard")
    public void setHard(Map<String, io.fabric8.kubernetes.api.model.Quantity> hard) {
        this.hard = hard;
    }

    /**
     * used is the current observed total usage of the resource in the namespace
     * 
     * @return
     *     The used
     */
    @JsonProperty("used")
    public Map<String, io.fabric8.kubernetes.api.model.Quantity> getUsed() {
        return used;
    }

    /**
     * used is the current observed total usage of the resource in the namespace
     * 
     * @param used
     *     The used
     */
    @JsonProperty("used")
    public void setUsed(Map<String, io.fabric8.kubernetes.api.model.Quantity> used) {
        this.used = used;
    }

    @Override
    public java.lang.String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(hard).append(used).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof ResourceQuotaStatus) == false) {
            return false;
        }
        ResourceQuotaStatus rhs = ((ResourceQuotaStatus) other);
        return new EqualsBuilder().append(hard, rhs.hard).append(used, rhs.used).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
