
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "addresses",
    "capacity",
    "conditions",
    "nodeInfo",
    "phase"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class NodeStatus {

    /**
     * list of addresses reachable to the node
     * 
     */
    @JsonProperty("addresses")
    @Valid
    private List<NodeAddress> addresses = new ArrayList<NodeAddress>();
    /**
     * compute resource capacity of the node; http://docs.k8s.io/resources.md
     * 
     */
    @JsonProperty("capacity")
    @Valid
    private Map<String, Quantity> capacity;
    /**
     * list of node conditions observed
     * 
     */
    @JsonProperty("conditions")
    @Valid
    private List<NodeCondition> conditions = new ArrayList<NodeCondition>();
    /**
     * 
     * 
     */
    @JsonProperty("nodeInfo")
    @Valid
    private NodeSystemInfo nodeInfo;
    /**
     * most recently observed lifecycle phase of the node
     * 
     */
    @JsonProperty("phase")
    private java.lang.String phase;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public NodeStatus() {
    }

    /**
     * 
     * @param conditions
     * @param capacity
     * @param addresses
     * @param phase
     * @param nodeInfo
     */
    public NodeStatus(List<NodeAddress> addresses, Map<String, Quantity> capacity, List<NodeCondition> conditions, NodeSystemInfo nodeInfo, java.lang.String phase) {
        this.addresses = addresses;
        this.capacity = capacity;
        this.conditions = conditions;
        this.nodeInfo = nodeInfo;
        this.phase = phase;
    }

    /**
     * list of addresses reachable to the node
     * 
     * @return
     *     The addresses
     */
    @JsonProperty("addresses")
    public List<NodeAddress> getAddresses() {
        return addresses;
    }

    /**
     * list of addresses reachable to the node
     * 
     * @param addresses
     *     The addresses
     */
    @JsonProperty("addresses")
    public void setAddresses(List<NodeAddress> addresses) {
        this.addresses = addresses;
    }

    /**
     * compute resource capacity of the node; http://docs.k8s.io/resources.md
     * 
     * @return
     *     The capacity
     */
    @JsonProperty("capacity")
    public Map<String, Quantity> getCapacity() {
        return capacity;
    }

    /**
     * compute resource capacity of the node; http://docs.k8s.io/resources.md
     * 
     * @param capacity
     *     The capacity
     */
    @JsonProperty("capacity")
    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    /**
     * list of node conditions observed
     * 
     * @return
     *     The conditions
     */
    @JsonProperty("conditions")
    public List<NodeCondition> getConditions() {
        return conditions;
    }

    /**
     * list of node conditions observed
     * 
     * @param conditions
     *     The conditions
     */
    @JsonProperty("conditions")
    public void setConditions(List<NodeCondition> conditions) {
        this.conditions = conditions;
    }

    /**
     * 
     * 
     * @return
     *     The nodeInfo
     */
    @JsonProperty("nodeInfo")
    public NodeSystemInfo getNodeInfo() {
        return nodeInfo;
    }

    /**
     * 
     * 
     * @param nodeInfo
     *     The nodeInfo
     */
    @JsonProperty("nodeInfo")
    public void setNodeInfo(NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    /**
     * most recently observed lifecycle phase of the node
     * 
     * @return
     *     The phase
     */
    @JsonProperty("phase")
    public java.lang.String getPhase() {
        return phase;
    }

    /**
     * most recently observed lifecycle phase of the node
     * 
     * @param phase
     *     The phase
     */
    @JsonProperty("phase")
    public void setPhase(java.lang.String phase) {
        this.phase = phase;
    }

    @Override
    public java.lang.String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(addresses).append(capacity).append(conditions).append(nodeInfo).append(phase).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof NodeStatus) == false) {
            return false;
        }
        NodeStatus rhs = ((NodeStatus) other);
        return new EqualsBuilder().append(addresses, rhs.addresses).append(capacity, rhs.capacity).append(conditions, rhs.conditions).append(nodeInfo, rhs.nodeInfo).append(phase, rhs.phase).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
