package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class NFSVolumeSourceBuilder extends NFSVolumeSourceFluent<NFSVolumeSourceBuilder> implements VisitableBuilder<NFSVolumeSource,NFSVolumeSourceBuilder>{

     NFSVolumeSourceFluent<?> fluent;
public NFSVolumeSourceBuilder(){
    this(new NFSVolumeSource());
}
public NFSVolumeSourceBuilder( NFSVolumeSourceFluent<?> fluent ){
    this(fluent, new NFSVolumeSource());
}
public NFSVolumeSourceBuilder( NFSVolumeSourceFluent<?> fluent , NFSVolumeSource instance ){
    this.fluent = fluent; fluent.withPath(instance.getPath()); fluent.withReadOnly(instance.getReadOnly()); fluent.withServer(instance.getServer()); 
}
public NFSVolumeSourceBuilder( NFSVolumeSource instance ){
    this.fluent = this; this.withPath(instance.getPath()); this.withReadOnly(instance.getReadOnly()); this.withServer(instance.getServer()); 
}

public EditableNFSVolumeSource build(){
    EditableNFSVolumeSource buildable = new EditableNFSVolumeSource(fluent.getPath(),fluent.isReadOnly(),fluent.getServer());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    