package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class LifecycleBuilder extends LifecycleFluent<LifecycleBuilder> implements VisitableBuilder<Lifecycle,LifecycleBuilder>{

     LifecycleFluent<?> fluent;
public LifecycleBuilder(){
    this(new Lifecycle());
}
public LifecycleBuilder( LifecycleFluent<?> fluent ){
    this(fluent, new Lifecycle());
}
public LifecycleBuilder( LifecycleFluent<?> fluent , Lifecycle instance ){
    this.fluent = fluent; fluent.withPostStart(instance.getPostStart()); fluent.withPreStop(instance.getPreStop()); 
}
public LifecycleBuilder( Lifecycle instance ){
    this.fluent = this; this.withPostStart(instance.getPostStart()); this.withPreStop(instance.getPreStop()); 
}

public EditableLifecycle build(){
    EditableLifecycle buildable = new EditableLifecycle(fluent.getPostStart(),fluent.getPreStop());
validate(buildable);
return buildable;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    