
package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "client-certificate",
    "client-certificate-data",
    "client-key",
    "client-key-data",
    "extensions",
    "password",
    "token",
    "username"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
public class AuthInfo {

    /**
     * 
     * 
     */
    @JsonProperty("client-certificate")
    private String clientCertificate;
    /**
     * 
     * 
     */
    @JsonProperty("client-certificate-data")
    private String clientCertificateData;
    /**
     * 
     * 
     */
    @JsonProperty("client-key")
    private String clientKey;
    /**
     * 
     * 
     */
    @JsonProperty("client-key-data")
    private String clientKeyData;
    /**
     * 
     * 
     */
    @JsonProperty("extensions")
    @Valid
    private List<NamedExtension> extensions = new ArrayList<NamedExtension>();
    /**
     * 
     * 
     */
    @JsonProperty("password")
    private String password;
    /**
     * 
     * 
     */
    @JsonProperty("token")
    private String token;
    /**
     * 
     * 
     */
    @JsonProperty("username")
    private String username;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public AuthInfo() {
    }

    /**
     * 
     * @param username
     * @param token
     * @param clientCertificate
     * @param clientKey
     * @param password
     * @param extensions
     * @param clientKeyData
     * @param clientCertificateData
     */
    public AuthInfo(String clientCertificate, String clientCertificateData, String clientKey, String clientKeyData, List<NamedExtension> extensions, String password, String token, String username) {
        this.clientCertificate = clientCertificate;
        this.clientCertificateData = clientCertificateData;
        this.clientKey = clientKey;
        this.clientKeyData = clientKeyData;
        this.extensions = extensions;
        this.password = password;
        this.token = token;
        this.username = username;
    }

    /**
     * 
     * 
     * @return
     *     The clientCertificate
     */
    @JsonProperty("client-certificate")
    public String getClientCertificate() {
        return clientCertificate;
    }

    /**
     * 
     * 
     * @param clientCertificate
     *     The client-certificate
     */
    @JsonProperty("client-certificate")
    public void setClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
    }

    /**
     * 
     * 
     * @return
     *     The clientCertificateData
     */
    @JsonProperty("client-certificate-data")
    public String getClientCertificateData() {
        return clientCertificateData;
    }

    /**
     * 
     * 
     * @param clientCertificateData
     *     The client-certificate-data
     */
    @JsonProperty("client-certificate-data")
    public void setClientCertificateData(String clientCertificateData) {
        this.clientCertificateData = clientCertificateData;
    }

    /**
     * 
     * 
     * @return
     *     The clientKey
     */
    @JsonProperty("client-key")
    public String getClientKey() {
        return clientKey;
    }

    /**
     * 
     * 
     * @param clientKey
     *     The client-key
     */
    @JsonProperty("client-key")
    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    /**
     * 
     * 
     * @return
     *     The clientKeyData
     */
    @JsonProperty("client-key-data")
    public String getClientKeyData() {
        return clientKeyData;
    }

    /**
     * 
     * 
     * @param clientKeyData
     *     The client-key-data
     */
    @JsonProperty("client-key-data")
    public void setClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
    }

    /**
     * 
     * 
     * @return
     *     The extensions
     */
    @JsonProperty("extensions")
    public List<NamedExtension> getExtensions() {
        return extensions;
    }

    /**
     * 
     * 
     * @param extensions
     *     The extensions
     */
    @JsonProperty("extensions")
    public void setExtensions(List<NamedExtension> extensions) {
        this.extensions = extensions;
    }

    /**
     * 
     * 
     * @return
     *     The password
     */
    @JsonProperty("password")
    public String getPassword() {
        return password;
    }

    /**
     * 
     * 
     * @param password
     *     The password
     */
    @JsonProperty("password")
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * 
     * 
     * @return
     *     The token
     */
    @JsonProperty("token")
    public String getToken() {
        return token;
    }

    /**
     * 
     * 
     * @param token
     *     The token
     */
    @JsonProperty("token")
    public void setToken(String token) {
        this.token = token;
    }

    /**
     * 
     * 
     * @return
     *     The username
     */
    @JsonProperty("username")
    public String getUsername() {
        return username;
    }

    /**
     * 
     * 
     * @param username
     *     The username
     */
    @JsonProperty("username")
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(clientCertificate).append(clientCertificateData).append(clientKey).append(clientKeyData).append(extensions).append(password).append(token).append(username).append(additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof AuthInfo) == false) {
            return false;
        }
        AuthInfo rhs = ((AuthInfo) other);
        return new EqualsBuilder().append(clientCertificate, rhs.clientCertificate).append(clientCertificateData, rhs.clientCertificateData).append(clientKey, rhs.clientKey).append(clientKeyData, rhs.clientKeyData).append(extensions, rhs.extensions).append(password, rhs.password).append(token, rhs.token).append(username, rhs.username).append(additionalProperties, rhs.additionalProperties).isEquals();
    }

}
