package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class EnvVarSourceFluent<T extends EnvVarSourceFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<ObjectFieldSelector, ?> fieldRef;     Map<String, Object> additionalProperties = new HashMap();

    public ObjectFieldSelector getFieldRef(){
    return this.fieldRef!=null?this.fieldRef.build():null;
    }
    public T withFieldRef( ObjectFieldSelector fieldRef){
    if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.add(this.fieldRef);} return (T) this;
    }
    public FieldRefNested<T> withNewFieldRef(){
    return new FieldRefNested<T>();
    }
    public FieldRefNested<T> withNewFieldRefLike( ObjectFieldSelector item){
    return new FieldRefNested<T>(item);
    }
    public FieldRefNested<T> editFieldRef(){
    return withNewFieldRefLike(getFieldRef());
    }
    public T withNewFieldRef( String apiVersion,  String fieldPath){
    return withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class FieldRefNested<N> extends ObjectFieldSelectorFluent<FieldRefNested<N>> implements Nested<N>{

        private final ObjectFieldSelectorBuilder builder;
    
             FieldRefNested (){
        this.builder = new ObjectFieldSelectorBuilder(this);
        }
             FieldRefNested ( ObjectFieldSelector item){
        this.builder = new ObjectFieldSelectorBuilder(this, item);
        }
    
            public N and(){
            return (N) EnvVarSourceFluent.this.withFieldRef(builder.build());
        }
            public N endFieldRef(){
            return and();
        }
    
}


}
