package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.BuildRequestFluent;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageFluent;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.BuildFluent;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluent;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.TemplateFluent;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.BuildBuilder;
import io.fabric8.openshift.api.model.BuildConfigFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.OAuthClientFluent;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class BaseKubernetesListFluent<T extends BaseKubernetesListFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     BaseKubernetesList.ApiVersion apiVersion;     List<HasMetadata> items = new ArrayList();     List<VisitableBuilder<Build, ?>> buildItems = new ArrayList();     List<VisitableBuilder<BuildConfig, ?>> buildConfigItems = new ArrayList();     List<VisitableBuilder<BuildRequest, ?>> buildRequestItems = new ArrayList();     List<VisitableBuilder<DeploymentConfig, ?>> deploymentConfigItems = new ArrayList();     List<VisitableBuilder<Image, ?>> imageItems = new ArrayList();     List<VisitableBuilder<ImageStream, ?>> imageStreamItems = new ArrayList();     List<VisitableBuilder<OAuthAccessToken, ?>> oAuthAccessTokenItems = new ArrayList();     List<VisitableBuilder<OAuthAuthorizeToken, ?>> oAuthAuthorizeTokenItems = new ArrayList();     List<VisitableBuilder<OAuthClient, ?>> oAuthClientItems = new ArrayList();     List<VisitableBuilder<OAuthClientAuthorization, ?>> oAuthClientAuthorizationItems = new ArrayList();     List<VisitableBuilder<Route, ?>> routeItems = new ArrayList();     List<VisitableBuilder<Template, ?>> templateItems = new ArrayList();     List<VisitableBuilder<Endpoints, ?>> endpointsItems = new ArrayList();     List<VisitableBuilder<Event, ?>> eventItems = new ArrayList();     List<VisitableBuilder<Namespace, ?>> namespaceItems = new ArrayList();     List<VisitableBuilder<Node, ?>> nodeItems = new ArrayList();     List<VisitableBuilder<PersistentVolume, ?>> persistentVolumeItems = new ArrayList();     List<VisitableBuilder<PersistentVolumeClaim, ?>> persistentVolumeClaimItems = new ArrayList();     List<VisitableBuilder<Pod, ?>> podItems = new ArrayList();     List<VisitableBuilder<ReplicationController, ?>> replicationControllerItems = new ArrayList();     List<VisitableBuilder<ResourceQuota, ?>> resourceQuotaItems = new ArrayList();     List<VisitableBuilder<Secret, ?>> secretItems = new ArrayList();     List<VisitableBuilder<Service, ?>> serviceItems = new ArrayList();     List<VisitableBuilder<ServiceAccount, ?>> serviceAccountItems = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;     Map<String, Object> additionalProperties = new HashMap();

    public BaseKubernetesList.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( BaseKubernetesList.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public T addToItems( HasMetadata item){
    if (item instanceof Build){addToBuildItems((Build)item);}
 else if (item instanceof BuildConfig){addToBuildConfigItems((BuildConfig)item);}
 else if (item instanceof BuildRequest){addToBuildRequestItems((BuildRequest)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof Image){addToImageItems((Image)item);}
 else if (item instanceof ImageStream){addToImageStreamItems((ImageStream)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof OAuthClient){addToOAuthClientItems((OAuthClient)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof Route){addToRouteItems((Route)item);}
 else if (item instanceof Template){addToTemplateItems((Template)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}
return (T)this;
    }
    public List<HasMetadata> getItems(){
    return aggregate(build(buildItems), build(buildConfigItems), build(buildRequestItems), build(deploymentConfigItems), build(imageItems), build(imageStreamItems), build(oAuthAccessTokenItems), build(oAuthAuthorizeTokenItems), build(oAuthClientItems), build(oAuthClientAuthorizationItems), build(routeItems), build(templateItems), build(endpointsItems), build(eventItems), build(namespaceItems), build(nodeItems), build(persistentVolumeItems), build(persistentVolumeClaimItems), build(podItems), build(replicationControllerItems), build(resourceQuotaItems), build(secretItems), build(serviceItems), build(serviceAccountItems));
    }
    public T withItems( List<HasMetadata> items){
    this.items.clear();if (items != null) {for (HasMetadata item : items){this.addToItems(item);}} return (T) this;
    }
    public T addToBuildItems( Build item){
    if (item != null) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.buildItems.add(builder);} return (T)this;
    }
    public BuildItemsNested<T> addNewBuildItem(){
    return new BuildItemsNested<T>();
    }
    public BuildItemsNested<T> addNewBuildItemLike( Build item){
    return new BuildItemsNested<T>(item);
    }
    public T addToBuildConfigItems( BuildConfig item){
    if (item != null) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.buildConfigItems.add(builder);} return (T)this;
    }
    public BuildConfigItemsNested<T> addNewBuildConfigItem(){
    return new BuildConfigItemsNested<T>();
    }
    public BuildConfigItemsNested<T> addNewBuildConfigItemLike( BuildConfig item){
    return new BuildConfigItemsNested<T>(item);
    }
    public T addToBuildRequestItems( BuildRequest item){
    if (item != null) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.buildRequestItems.add(builder);} return (T)this;
    }
    public BuildRequestItemsNested<T> addNewBuildRequestItem(){
    return new BuildRequestItemsNested<T>();
    }
    public BuildRequestItemsNested<T> addNewBuildRequestItemLike( BuildRequest item){
    return new BuildRequestItemsNested<T>(item);
    }
    public T addToDeploymentConfigItems( DeploymentConfig item){
    if (item != null) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.deploymentConfigItems.add(builder);} return (T)this;
    }
    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItem(){
    return new DeploymentConfigItemsNested<T>();
    }
    public DeploymentConfigItemsNested<T> addNewDeploymentConfigItemLike( DeploymentConfig item){
    return new DeploymentConfigItemsNested<T>(item);
    }
    public T addToImageItems( Image item){
    if (item != null) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.imageItems.add(builder);} return (T)this;
    }
    public ImageItemsNested<T> addNewImageItem(){
    return new ImageItemsNested<T>();
    }
    public ImageItemsNested<T> addNewImageItemLike( Image item){
    return new ImageItemsNested<T>(item);
    }
    public T addToImageStreamItems( ImageStream item){
    if (item != null) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.imageStreamItems.add(builder);} return (T)this;
    }
    public ImageStreamItemsNested<T> addNewImageStreamItem(){
    return new ImageStreamItemsNested<T>();
    }
    public ImageStreamItemsNested<T> addNewImageStreamItemLike( ImageStream item){
    return new ImageStreamItemsNested<T>(item);
    }
    public T addToOAuthAccessTokenItems( OAuthAccessToken item){
    if (item != null) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.oAuthAccessTokenItems.add(builder);} return (T)this;
    }
    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItem(){
    return new OAuthAccessTokenItemsNested<T>();
    }
    public OAuthAccessTokenItemsNested<T> addNewOAuthAccessTokenItemLike( OAuthAccessToken item){
    return new OAuthAccessTokenItemsNested<T>(item);
    }
    public T addToOAuthAuthorizeTokenItems( OAuthAuthorizeToken item){
    if (item != null) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.oAuthAuthorizeTokenItems.add(builder);} return (T)this;
    }
    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItem(){
    return new OAuthAuthorizeTokenItemsNested<T>();
    }
    public OAuthAuthorizeTokenItemsNested<T> addNewOAuthAuthorizeTokenItemLike( OAuthAuthorizeToken item){
    return new OAuthAuthorizeTokenItemsNested<T>(item);
    }
    public T addToOAuthClientItems( OAuthClient item){
    if (item != null) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.oAuthClientItems.add(builder);} return (T)this;
    }
    public OAuthClientItemsNested<T> addNewOAuthClientItem(){
    return new OAuthClientItemsNested<T>();
    }
    public OAuthClientItemsNested<T> addNewOAuthClientItemLike( OAuthClient item){
    return new OAuthClientItemsNested<T>(item);
    }
    public T addToOAuthClientAuthorizationItems( OAuthClientAuthorization item){
    if (item != null) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.oAuthClientAuthorizationItems.add(builder);} return (T)this;
    }
    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItem(){
    return new OAuthClientAuthorizationItemsNested<T>();
    }
    public OAuthClientAuthorizationItemsNested<T> addNewOAuthClientAuthorizationItemLike( OAuthClientAuthorization item){
    return new OAuthClientAuthorizationItemsNested<T>(item);
    }
    public T addToRouteItems( Route item){
    if (item != null) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.routeItems.add(builder);} return (T)this;
    }
    public RouteItemsNested<T> addNewRouteItem(){
    return new RouteItemsNested<T>();
    }
    public RouteItemsNested<T> addNewRouteItemLike( Route item){
    return new RouteItemsNested<T>(item);
    }
    public T addToTemplateItems( Template item){
    if (item != null) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.templateItems.add(builder);} return (T)this;
    }
    public TemplateItemsNested<T> addNewTemplateItem(){
    return new TemplateItemsNested<T>();
    }
    public TemplateItemsNested<T> addNewTemplateItemLike( Template item){
    return new TemplateItemsNested<T>(item);
    }
    public T addToEndpointsItems( Endpoints item){
    if (item != null) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.endpointsItems.add(builder);} return (T)this;
    }
    public EndpointsItemsNested<T> addNewEndpointsItem(){
    return new EndpointsItemsNested<T>();
    }
    public EndpointsItemsNested<T> addNewEndpointsItemLike( Endpoints item){
    return new EndpointsItemsNested<T>(item);
    }
    public T addToEventItems( Event item){
    if (item != null) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.eventItems.add(builder);} return (T)this;
    }
    public EventItemsNested<T> addNewEventItem(){
    return new EventItemsNested<T>();
    }
    public EventItemsNested<T> addNewEventItemLike( Event item){
    return new EventItemsNested<T>(item);
    }
    public T addToNamespaceItems( Namespace item){
    if (item != null) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.namespaceItems.add(builder);} return (T)this;
    }
    public NamespaceItemsNested<T> addNewNamespaceItem(){
    return new NamespaceItemsNested<T>();
    }
    public NamespaceItemsNested<T> addNewNamespaceItemLike( Namespace item){
    return new NamespaceItemsNested<T>(item);
    }
    public T addToNodeItems( Node item){
    if (item != null) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.nodeItems.add(builder);} return (T)this;
    }
    public NodeItemsNested<T> addNewNodeItem(){
    return new NodeItemsNested<T>();
    }
    public NodeItemsNested<T> addNewNodeItemLike( Node item){
    return new NodeItemsNested<T>(item);
    }
    public T addToPersistentVolumeItems( PersistentVolume item){
    if (item != null) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.persistentVolumeItems.add(builder);} return (T)this;
    }
    public PersistentVolumeItemsNested<T> addNewPersistentVolumeItem(){
    return new PersistentVolumeItemsNested<T>();
    }
    public PersistentVolumeItemsNested<T> addNewPersistentVolumeItemLike( PersistentVolume item){
    return new PersistentVolumeItemsNested<T>(item);
    }
    public T addToPersistentVolumeClaimItems( PersistentVolumeClaim item){
    if (item != null) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.persistentVolumeClaimItems.add(builder);} return (T)this;
    }
    public PersistentVolumeClaimItemsNested<T> addNewPersistentVolumeClaimItem(){
    return new PersistentVolumeClaimItemsNested<T>();
    }
    public PersistentVolumeClaimItemsNested<T> addNewPersistentVolumeClaimItemLike( PersistentVolumeClaim item){
    return new PersistentVolumeClaimItemsNested<T>(item);
    }
    public T addToPodItems( Pod item){
    if (item != null) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.podItems.add(builder);} return (T)this;
    }
    public PodItemsNested<T> addNewPodItem(){
    return new PodItemsNested<T>();
    }
    public PodItemsNested<T> addNewPodItemLike( Pod item){
    return new PodItemsNested<T>(item);
    }
    public T addToReplicationControllerItems( ReplicationController item){
    if (item != null) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.replicationControllerItems.add(builder);} return (T)this;
    }
    public ReplicationControllerItemsNested<T> addNewReplicationControllerItem(){
    return new ReplicationControllerItemsNested<T>();
    }
    public ReplicationControllerItemsNested<T> addNewReplicationControllerItemLike( ReplicationController item){
    return new ReplicationControllerItemsNested<T>(item);
    }
    public T addToResourceQuotaItems( ResourceQuota item){
    if (item != null) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.resourceQuotaItems.add(builder);} return (T)this;
    }
    public ResourceQuotaItemsNested<T> addNewResourceQuotaItem(){
    return new ResourceQuotaItemsNested<T>();
    }
    public ResourceQuotaItemsNested<T> addNewResourceQuotaItemLike( ResourceQuota item){
    return new ResourceQuotaItemsNested<T>(item);
    }
    public T addToSecretItems( Secret item){
    if (item != null) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.secretItems.add(builder);} return (T)this;
    }
    public SecretItemsNested<T> addNewSecretItem(){
    return new SecretItemsNested<T>();
    }
    public SecretItemsNested<T> addNewSecretItemLike( Secret item){
    return new SecretItemsNested<T>(item);
    }
    public T addToServiceItems( Service item){
    if (item != null) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.serviceItems.add(builder);} return (T)this;
    }
    public ServiceItemsNested<T> addNewServiceItem(){
    return new ServiceItemsNested<T>();
    }
    public ServiceItemsNested<T> addNewServiceItemLike( Service item){
    return new ServiceItemsNested<T>(item);
    }
    public T addToServiceAccountItems( ServiceAccount item){
    if (item != null) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.serviceAccountItems.add(builder);} return (T)this;
    }
    public ServiceAccountItemsNested<T> addNewServiceAccountItem(){
    return new ServiceAccountItemsNested<T>();
    }
    public ServiceAccountItemsNested<T> addNewServiceAccountItemLike( ServiceAccount item){
    return new ServiceAccountItemsNested<T>(item);
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }

    public class BuildItemsNested<N> extends BuildFluent<BuildItemsNested<N>> implements Nested<N>{

        private final BuildBuilder builder;
    
             BuildItemsNested (){
        this.builder = new BuildBuilder(this);
        }
             BuildItemsNested ( Build item){
        this.builder = new BuildBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToBuildItems(builder.build());
        }
            public N endBuildItem(){
            return and();
        }
    
}
    public class BuildConfigItemsNested<N> extends BuildConfigFluent<BuildConfigItemsNested<N>> implements Nested<N>{

        private final BuildConfigBuilder builder;
    
             BuildConfigItemsNested (){
        this.builder = new BuildConfigBuilder(this);
        }
             BuildConfigItemsNested ( BuildConfig item){
        this.builder = new BuildConfigBuilder(this, item);
        }
    
            public N endBuildConfigItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToBuildConfigItems(builder.build());
        }
    
}
    public class BuildRequestItemsNested<N> extends BuildRequestFluent<BuildRequestItemsNested<N>> implements Nested<N>{

        private final BuildRequestBuilder builder;
    
             BuildRequestItemsNested (){
        this.builder = new BuildRequestBuilder(this);
        }
             BuildRequestItemsNested ( BuildRequest item){
        this.builder = new BuildRequestBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToBuildRequestItems(builder.build());
        }
            public N endBuildRequestItem(){
            return and();
        }
    
}
    public class DeploymentConfigItemsNested<N> extends DeploymentConfigFluent<DeploymentConfigItemsNested<N>> implements Nested<N>{

        private final DeploymentConfigBuilder builder;
    
             DeploymentConfigItemsNested (){
        this.builder = new DeploymentConfigBuilder(this);
        }
             DeploymentConfigItemsNested ( DeploymentConfig item){
        this.builder = new DeploymentConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToDeploymentConfigItems(builder.build());
        }
            public N endDeploymentConfigItem(){
            return and();
        }
    
}
    public class ImageItemsNested<N> extends ImageFluent<ImageItemsNested<N>> implements Nested<N>{

        private final ImageBuilder builder;
    
             ImageItemsNested ( Image item){
        this.builder = new ImageBuilder(this, item);
        }
             ImageItemsNested (){
        this.builder = new ImageBuilder(this);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToImageItems(builder.build());
        }
            public N endImageItem(){
            return and();
        }
    
}
    public class ImageStreamItemsNested<N> extends ImageStreamFluent<ImageStreamItemsNested<N>> implements Nested<N>{

        private final ImageStreamBuilder builder;
    
             ImageStreamItemsNested (){
        this.builder = new ImageStreamBuilder(this);
        }
             ImageStreamItemsNested ( ImageStream item){
        this.builder = new ImageStreamBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToImageStreamItems(builder.build());
        }
            public N endImageStreamItem(){
            return and();
        }
    
}
    public class OAuthAccessTokenItemsNested<N> extends OAuthAccessTokenFluent<OAuthAccessTokenItemsNested<N>> implements Nested<N>{

        private final OAuthAccessTokenBuilder builder;
    
             OAuthAccessTokenItemsNested (){
        this.builder = new OAuthAccessTokenBuilder(this);
        }
             OAuthAccessTokenItemsNested ( OAuthAccessToken item){
        this.builder = new OAuthAccessTokenBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToOAuthAccessTokenItems(builder.build());
        }
            public N endOAuthAccessTokenItem(){
            return and();
        }
    
}
    public class OAuthAuthorizeTokenItemsNested<N> extends OAuthAuthorizeTokenFluent<OAuthAuthorizeTokenItemsNested<N>> implements Nested<N>{

        private final OAuthAuthorizeTokenBuilder builder;
    
             OAuthAuthorizeTokenItemsNested (){
        this.builder = new OAuthAuthorizeTokenBuilder(this);
        }
             OAuthAuthorizeTokenItemsNested ( OAuthAuthorizeToken item){
        this.builder = new OAuthAuthorizeTokenBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToOAuthAuthorizeTokenItems(builder.build());
        }
            public N endOAuthAuthorizeTokenItem(){
            return and();
        }
    
}
    public class OAuthClientItemsNested<N> extends OAuthClientFluent<OAuthClientItemsNested<N>> implements Nested<N>{

        private final OAuthClientBuilder builder;
    
             OAuthClientItemsNested ( OAuthClient item){
        this.builder = new OAuthClientBuilder(this, item);
        }
             OAuthClientItemsNested (){
        this.builder = new OAuthClientBuilder(this);
        }
    
            public N endOAuthClientItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToOAuthClientItems(builder.build());
        }
    
}
    public class OAuthClientAuthorizationItemsNested<N> extends OAuthClientAuthorizationFluent<OAuthClientAuthorizationItemsNested<N>> implements Nested<N>{

        private final OAuthClientAuthorizationBuilder builder;
    
             OAuthClientAuthorizationItemsNested (){
        this.builder = new OAuthClientAuthorizationBuilder(this);
        }
             OAuthClientAuthorizationItemsNested ( OAuthClientAuthorization item){
        this.builder = new OAuthClientAuthorizationBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToOAuthClientAuthorizationItems(builder.build());
        }
            public N endOAuthClientAuthorizationItem(){
            return and();
        }
    
}
    public class RouteItemsNested<N> extends RouteFluent<RouteItemsNested<N>> implements Nested<N>{

        private final RouteBuilder builder;
    
             RouteItemsNested (){
        this.builder = new RouteBuilder(this);
        }
             RouteItemsNested ( Route item){
        this.builder = new RouteBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToRouteItems(builder.build());
        }
            public N endRouteItem(){
            return and();
        }
    
}
    public class TemplateItemsNested<N> extends TemplateFluent<TemplateItemsNested<N>> implements Nested<N>{

        private final TemplateBuilder builder;
    
             TemplateItemsNested (){
        this.builder = new TemplateBuilder(this);
        }
             TemplateItemsNested ( Template item){
        this.builder = new TemplateBuilder(this, item);
        }
    
            public N endTemplateItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToTemplateItems(builder.build());
        }
    
}
    public class EndpointsItemsNested<N> extends EndpointsFluent<EndpointsItemsNested<N>> implements Nested<N>{

        private final EndpointsBuilder builder;
    
             EndpointsItemsNested (){
        this.builder = new EndpointsBuilder(this);
        }
             EndpointsItemsNested ( Endpoints item){
        this.builder = new EndpointsBuilder(this, item);
        }
    
            public N endEndpointsItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToEndpointsItems(builder.build());
        }
    
}
    public class EventItemsNested<N> extends EventFluent<EventItemsNested<N>> implements Nested<N>{

        private final EventBuilder builder;
    
             EventItemsNested (){
        this.builder = new EventBuilder(this);
        }
             EventItemsNested ( Event item){
        this.builder = new EventBuilder(this, item);
        }
    
            public N endEventItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToEventItems(builder.build());
        }
    
}
    public class NamespaceItemsNested<N> extends NamespaceFluent<NamespaceItemsNested<N>> implements Nested<N>{

        private final NamespaceBuilder builder;
    
             NamespaceItemsNested ( Namespace item){
        this.builder = new NamespaceBuilder(this, item);
        }
             NamespaceItemsNested (){
        this.builder = new NamespaceBuilder(this);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToNamespaceItems(builder.build());
        }
            public N endNamespaceItem(){
            return and();
        }
    
}
    public class NodeItemsNested<N> extends NodeFluent<NodeItemsNested<N>> implements Nested<N>{

        private final NodeBuilder builder;
    
             NodeItemsNested ( Node item){
        this.builder = new NodeBuilder(this, item);
        }
             NodeItemsNested (){
        this.builder = new NodeBuilder(this);
        }
    
            public N endNodeItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToNodeItems(builder.build());
        }
    
}
    public class PersistentVolumeItemsNested<N> extends PersistentVolumeFluent<PersistentVolumeItemsNested<N>> implements Nested<N>{

        private final PersistentVolumeBuilder builder;
    
             PersistentVolumeItemsNested ( PersistentVolume item){
        this.builder = new PersistentVolumeBuilder(this, item);
        }
             PersistentVolumeItemsNested (){
        this.builder = new PersistentVolumeBuilder(this);
        }
    
            public N endPersistentVolumeItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToPersistentVolumeItems(builder.build());
        }
    
}
    public class PersistentVolumeClaimItemsNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimItemsNested<N>> implements Nested<N>{

        private final PersistentVolumeClaimBuilder builder;
    
             PersistentVolumeClaimItemsNested (){
        this.builder = new PersistentVolumeClaimBuilder(this);
        }
             PersistentVolumeClaimItemsNested ( PersistentVolumeClaim item){
        this.builder = new PersistentVolumeClaimBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToPersistentVolumeClaimItems(builder.build());
        }
            public N endPersistentVolumeClaimItem(){
            return and();
        }
    
}
    public class PodItemsNested<N> extends PodFluent<PodItemsNested<N>> implements Nested<N>{

        private final PodBuilder builder;
    
             PodItemsNested (){
        this.builder = new PodBuilder(this);
        }
             PodItemsNested ( Pod item){
        this.builder = new PodBuilder(this, item);
        }
    
            public N endPodItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToPodItems(builder.build());
        }
    
}
    public class ReplicationControllerItemsNested<N> extends ReplicationControllerFluent<ReplicationControllerItemsNested<N>> implements Nested<N>{

        private final ReplicationControllerBuilder builder;
    
             ReplicationControllerItemsNested (){
        this.builder = new ReplicationControllerBuilder(this);
        }
             ReplicationControllerItemsNested ( ReplicationController item){
        this.builder = new ReplicationControllerBuilder(this, item);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToReplicationControllerItems(builder.build());
        }
            public N endReplicationControllerItem(){
            return and();
        }
    
}
    public class ResourceQuotaItemsNested<N> extends ResourceQuotaFluent<ResourceQuotaItemsNested<N>> implements Nested<N>{

        private final ResourceQuotaBuilder builder;
    
             ResourceQuotaItemsNested ( ResourceQuota item){
        this.builder = new ResourceQuotaBuilder(this, item);
        }
             ResourceQuotaItemsNested (){
        this.builder = new ResourceQuotaBuilder(this);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToResourceQuotaItems(builder.build());
        }
            public N endResourceQuotaItem(){
            return and();
        }
    
}
    public class SecretItemsNested<N> extends SecretFluent<SecretItemsNested<N>> implements Nested<N>{

        private final SecretBuilder builder;
    
             SecretItemsNested ( Secret item){
        this.builder = new SecretBuilder(this, item);
        }
             SecretItemsNested (){
        this.builder = new SecretBuilder(this);
        }
    
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToSecretItems(builder.build());
        }
            public N endSecretItem(){
            return and();
        }
    
}
    public class ServiceItemsNested<N> extends ServiceFluent<ServiceItemsNested<N>> implements Nested<N>{

        private final ServiceBuilder builder;
    
             ServiceItemsNested (){
        this.builder = new ServiceBuilder(this);
        }
             ServiceItemsNested ( Service item){
        this.builder = new ServiceBuilder(this, item);
        }
    
            public N endServiceItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToServiceItems(builder.build());
        }
    
}
    public class ServiceAccountItemsNested<N> extends ServiceAccountFluent<ServiceAccountItemsNested<N>> implements Nested<N>{

        private final ServiceAccountBuilder builder;
    
             ServiceAccountItemsNested ( ServiceAccount item){
        this.builder = new ServiceAccountBuilder(this, item);
        }
             ServiceAccountItemsNested (){
        this.builder = new ServiceAccountBuilder(this);
        }
    
            public N endServiceAccountItem(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.addToServiceAccountItems(builder.build());
        }
    
}
    public class MetadataNested<N> extends ListMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNested ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) BaseKubernetesListFluent.this.withMetadata(builder.build());
        }
    
}


}
