package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeErrorBuilder extends VolumeErrorFluent<VolumeErrorBuilder> implements VisitableBuilder<VolumeError,VolumeErrorBuilder>{
  public VolumeErrorBuilder() {
    this(false);
  }
  public VolumeErrorBuilder(Boolean validationEnabled) {
    this(new VolumeError(), validationEnabled);
  }
  public VolumeErrorBuilder(VolumeErrorFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeErrorBuilder(VolumeErrorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeError(), validationEnabled);
  }
  public VolumeErrorBuilder(VolumeErrorFluent<?> fluent,VolumeError instance) {
    this(fluent, instance, false);
  }
  public VolumeErrorBuilder(VolumeErrorFluent<?> fluent,VolumeError instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VolumeError());

    if (instance != null) {
      fluent.withMessage(instance.getMessage());
      fluent.withTime(instance.getTime());
      fluent.withMessage(instance.getMessage());
      fluent.withTime(instance.getTime());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeErrorBuilder(VolumeError instance) {
    this(instance,false);
  }
  public VolumeErrorBuilder(VolumeError instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VolumeError());

    if (instance != null) {
      this.withMessage(instance.getMessage());
      this.withTime(instance.getTime());
      this.withMessage(instance.getMessage());
      this.withTime(instance.getTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeErrorFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeError build() {
    VolumeError buildable = new VolumeError(fluent.getMessage(),fluent.getTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}