package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSINodeBuilder extends CSINodeFluent<CSINodeBuilder> implements VisitableBuilder<CSINode,CSINodeBuilder>{
  public CSINodeBuilder() {
    this(false);
  }
  public CSINodeBuilder(Boolean validationEnabled) {
    this(new CSINode(), validationEnabled);
  }
  public CSINodeBuilder(CSINodeFluent<?> fluent) {
    this(fluent, false);
  }
  public CSINodeBuilder(CSINodeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSINode(), validationEnabled);
  }
  public CSINodeBuilder(CSINodeFluent<?> fluent,CSINode instance) {
    this(fluent, instance, false);
  }
  public CSINodeBuilder(CSINodeFluent<?> fluent,CSINode instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CSINode());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CSINodeBuilder(CSINode instance) {
    this(instance,false);
  }
  public CSINodeBuilder(CSINode instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CSINode());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CSINodeFluent<?> fluent;
  Boolean validationEnabled;
  public CSINode build() {
    CSINode buildable = new CSINode(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}