package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenRequestBuilder extends TokenRequestFluentImpl<TokenRequestBuilder> implements VisitableBuilder<TokenRequest,TokenRequestBuilder>{
  public TokenRequestBuilder() {
    this(false);
  }
  public TokenRequestBuilder(Boolean validationEnabled) {
    this(new TokenRequest(), validationEnabled);
  }
  public TokenRequestBuilder(TokenRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenRequestBuilder(TokenRequestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TokenRequest(), validationEnabled);
  }
  public TokenRequestBuilder(TokenRequestFluent<?> fluent,TokenRequest instance) {
    this(fluent, instance, false);
  }
  public TokenRequestBuilder(TokenRequestFluent<?> fluent,TokenRequest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAudience(instance.getAudience());
      fluent.withExpirationSeconds(instance.getExpirationSeconds());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TokenRequestBuilder(TokenRequest instance) {
    this(instance,false);
  }
  public TokenRequestBuilder(TokenRequest instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAudience(instance.getAudience());
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TokenRequestFluent<?> fluent;
  Boolean validationEnabled;
  public TokenRequest build() {
    TokenRequest buildable = new TokenRequest(fluent.getAudience(),fluent.getExpirationSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}