package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CSIStorageCapacityFluentImpl<A extends CSIStorageCapacityFluent<A>> extends BaseFluent<A> implements CSIStorageCapacityFluent<A>{
  public CSIStorageCapacityFluentImpl() {
  }
  public CSIStorageCapacityFluentImpl(CSIStorageCapacity instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withCapacity(instance.getCapacity());
      this.withKind(instance.getKind());
      this.withMaximumVolumeSize(instance.getMaximumVolumeSize());
      this.withMetadata(instance.getMetadata());
      this.withNodeTopology(instance.getNodeTopology());
      this.withStorageClassName(instance.getStorageClassName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private Quantity capacity;
  private String kind;
  private Quantity maximumVolumeSize;
  private ObjectMetaBuilder metadata;
  private LabelSelectorBuilder nodeTopology;
  private String storageClassName;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public Quantity getCapacity() {
    return this.capacity;
  }
  public A withCapacity(Quantity capacity) {
    this.capacity=capacity; return (A) this;
  }
  public Boolean hasCapacity() {
    return this.capacity != null;
  }
  public A withNewCapacity(String amount,String format) {
    return (A)withCapacity(new Quantity(amount, format));
  }
  public A withNewCapacity(String amount) {
    return (A)withCapacity(new Quantity(amount));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public Quantity getMaximumVolumeSize() {
    return this.maximumVolumeSize;
  }
  public A withMaximumVolumeSize(Quantity maximumVolumeSize) {
    this.maximumVolumeSize=maximumVolumeSize; return (A) this;
  }
  public Boolean hasMaximumVolumeSize() {
    return this.maximumVolumeSize != null;
  }
  public A withNewMaximumVolumeSize(String amount,String format) {
    return (A)withMaximumVolumeSize(new Quantity(amount, format));
  }
  public A withNewMaximumVolumeSize(String amount) {
    return (A)withMaximumVolumeSize(new Quantity(amount));
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public CSIStorageCapacityFluentImpl.MetadataNested<A> withNewMetadata() {
    return new CSIStorageCapacityFluentImpl.MetadataNestedImpl();
  }
  public CSIStorageCapacityFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new CSIStorageCapacityFluentImpl.MetadataNestedImpl(item);
  }
  public CSIStorageCapacityFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public CSIStorageCapacityFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public CSIStorageCapacityFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeTopology instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNodeTopology() {
    return this.nodeTopology!=null ?this.nodeTopology.build():null;
  }
  public LabelSelector buildNodeTopology() {
    return this.nodeTopology!=null ?this.nodeTopology.build():null;
  }
  public A withNodeTopology(LabelSelector nodeTopology) {
    _visitables.get("nodeTopology").remove(this.nodeTopology);
    if (nodeTopology!=null){ this.nodeTopology= new LabelSelectorBuilder(nodeTopology); _visitables.get("nodeTopology").add(this.nodeTopology);} else { this.nodeTopology = null; _visitables.get("nodeTopology").remove(this.nodeTopology); } return (A) this;
  }
  public Boolean hasNodeTopology() {
    return this.nodeTopology != null;
  }
  public CSIStorageCapacityFluentImpl.NodeTopologyNested<A> withNewNodeTopology() {
    return new CSIStorageCapacityFluentImpl.NodeTopologyNestedImpl();
  }
  public CSIStorageCapacityFluentImpl.NodeTopologyNested<A> withNewNodeTopologyLike(LabelSelector item) {
    return new CSIStorageCapacityFluentImpl.NodeTopologyNestedImpl(item);
  }
  public CSIStorageCapacityFluentImpl.NodeTopologyNested<A> editNodeTopology() {
    return withNewNodeTopologyLike(getNodeTopology());
  }
  public CSIStorageCapacityFluentImpl.NodeTopologyNested<A> editOrNewNodeTopology() {
    return withNewNodeTopologyLike(getNodeTopology() != null ? getNodeTopology(): new LabelSelectorBuilder().build());
  }
  public CSIStorageCapacityFluentImpl.NodeTopologyNested<A> editOrNewNodeTopologyLike(LabelSelector item) {
    return withNewNodeTopologyLike(getNodeTopology() != null ? getNodeTopology(): item);
  }
  public String getStorageClassName() {
    return this.storageClassName;
  }
  public A withStorageClassName(String storageClassName) {
    this.storageClassName=storageClassName; return (A) this;
  }
  public Boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CSIStorageCapacityFluentImpl that = (CSIStorageCapacityFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(capacity, that.capacity)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(maximumVolumeSize, that.maximumVolumeSize)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(nodeTopology, that.nodeTopology)) return false;

    if (!java.util.Objects.equals(storageClassName, that.storageClassName)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  capacity,  kind,  maximumVolumeSize,  metadata,  nodeTopology,  storageClassName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (capacity != null) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (maximumVolumeSize != null) { sb.append("maximumVolumeSize:"); sb.append(maximumVolumeSize + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (nodeTopology != null) { sb.append("nodeTopology:"); sb.append(nodeTopology + ","); }
    if (storageClassName != null) { sb.append("storageClassName:"); sb.append(storageClassName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<CSIStorageCapacityFluentImpl.MetadataNested<N>> implements CSIStorageCapacityFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) CSIStorageCapacityFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class NodeTopologyNestedImpl<N> extends LabelSelectorFluentImpl<CSIStorageCapacityFluentImpl.NodeTopologyNested<N>> implements CSIStorageCapacityFluentImpl.NodeTopologyNested<N>,Nested<N>{
    NodeTopologyNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NodeTopologyNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) CSIStorageCapacityFluentImpl.this.withNodeTopology(builder.build());
    }
    public N endNodeTopology() {
      return and();
    }
    
  }
  
}