package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeAttachmentSourceBuilder extends VolumeAttachmentSourceFluentImpl<VolumeAttachmentSourceBuilder> implements VisitableBuilder<VolumeAttachmentSource,VolumeAttachmentSourceBuilder>{
  public VolumeAttachmentSourceBuilder() {
    this(false);
  }
  public VolumeAttachmentSourceBuilder(Boolean validationEnabled) {
    this(new VolumeAttachmentSource(), validationEnabled);
  }
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeAttachmentSource(), validationEnabled);
  }
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent,VolumeAttachmentSource instance) {
    this(fluent, instance, false);
  }
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSourceFluent<?> fluent,VolumeAttachmentSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withInlineVolumeSpec(instance.getInlineVolumeSpec());
      fluent.withPersistentVolumeName(instance.getPersistentVolumeName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSource instance) {
    this(instance,false);
  }
  public VolumeAttachmentSourceBuilder(VolumeAttachmentSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withInlineVolumeSpec(instance.getInlineVolumeSpec());
      this.withPersistentVolumeName(instance.getPersistentVolumeName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeAttachmentSourceFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeAttachmentSource build() {
    VolumeAttachmentSource buildable = new VolumeAttachmentSource(fluent.getInlineVolumeSpec(),fluent.getPersistentVolumeName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}