package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSIStorageCapacityBuilder extends CSIStorageCapacityFluentImpl<CSIStorageCapacityBuilder> implements VisitableBuilder<CSIStorageCapacity,CSIStorageCapacityBuilder>{
  public CSIStorageCapacityBuilder() {
    this(false);
  }
  public CSIStorageCapacityBuilder(Boolean validationEnabled) {
    this(new CSIStorageCapacity(), validationEnabled);
  }
  public CSIStorageCapacityBuilder(CSIStorageCapacityFluent<?> fluent) {
    this(fluent, false);
  }
  public CSIStorageCapacityBuilder(CSIStorageCapacityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSIStorageCapacity(), validationEnabled);
  }
  public CSIStorageCapacityBuilder(CSIStorageCapacityFluent<?> fluent,CSIStorageCapacity instance) {
    this(fluent, instance, false);
  }
  public CSIStorageCapacityBuilder(CSIStorageCapacityFluent<?> fluent,CSIStorageCapacity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withCapacity(instance.getCapacity()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMaximumVolumeSize(instance.getMaximumVolumeSize()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withNodeTopology(instance.getNodeTopology()); 
    fluent.withStorageClassName(instance.getStorageClassName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSIStorageCapacityBuilder(CSIStorageCapacity instance) {
    this(instance,false);
  }
  public CSIStorageCapacityBuilder(CSIStorageCapacity instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withCapacity(instance.getCapacity()); 
    this.withKind(instance.getKind()); 
    this.withMaximumVolumeSize(instance.getMaximumVolumeSize()); 
    this.withMetadata(instance.getMetadata()); 
    this.withNodeTopology(instance.getNodeTopology()); 
    this.withStorageClassName(instance.getStorageClassName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CSIStorageCapacityFluent<?> fluent;
  Boolean validationEnabled;
  public CSIStorageCapacity build() {
    CSIStorageCapacity buildable = new CSIStorageCapacity(fluent.getApiVersion(),fluent.getCapacity(),fluent.getKind(),fluent.getMaximumVolumeSize(),fluent.getMetadata(),fluent.getNodeTopology(),fluent.getStorageClassName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}