package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CSINodeSpecFluentImpl<A extends CSINodeSpecFluent<A>> extends BaseFluent<A> implements CSINodeSpecFluent<A>{
  public CSINodeSpecFluentImpl() {
  }
  public CSINodeSpecFluentImpl(CSINodeSpec instance) {
    this.withDrivers(instance.getDrivers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<CSINodeDriverBuilder> drivers = new ArrayList<CSINodeDriverBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToDrivers(Integer index,CSINodeDriver item) {
    if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
    CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").add(index >= 0 ? index : _visitables.get("drivers").size(), builder);this.drivers.add(index >= 0 ? index : drivers.size(), builder); return (A)this;
  }
  public A setToDrivers(Integer index,CSINodeDriver item) {
    if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
    CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);
    if (index < 0 || index >= _visitables.get("drivers").size()) { _visitables.get("drivers").add(builder); } else { _visitables.get("drivers").set(index, builder);}
    if (index < 0 || index >= drivers.size()) { drivers.add(builder); } else { drivers.set(index, builder);}
     return (A)this;
  }
  public A addToDrivers(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver... items) {
    if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
    for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").add(builder);this.drivers.add(builder);} return (A)this;
  }
  public A addAllToDrivers(Collection<CSINodeDriver> items) {
    if (this.drivers == null) {this.drivers = new ArrayList<CSINodeDriverBuilder>();}
    for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").add(builder);this.drivers.add(builder);} return (A)this;
  }
  public A removeFromDrivers(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver... items) {
    for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").remove(builder);if (this.drivers != null) {this.drivers.remove(builder);}} return (A)this;
  }
  public A removeAllFromDrivers(Collection<CSINodeDriver> items) {
    for (CSINodeDriver item : items) {CSINodeDriverBuilder builder = new CSINodeDriverBuilder(item);_visitables.get("drivers").remove(builder);if (this.drivers != null) {this.drivers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDrivers(Predicate<CSINodeDriverBuilder> predicate) {
    if (drivers == null) return (A) this;
    final Iterator<CSINodeDriverBuilder> each = drivers.iterator();
    final List visitables = _visitables.get("drivers");
    while (each.hasNext()) {
      CSINodeDriverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDrivers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CSINodeDriver> getDrivers() {
    return drivers != null ? build(drivers) : null;
  }
  public List<CSINodeDriver> buildDrivers() {
    return drivers != null ? build(drivers) : null;
  }
  public CSINodeDriver buildDriver(Integer index) {
    return this.drivers.get(index).build();
  }
  public CSINodeDriver buildFirstDriver() {
    return this.drivers.get(0).build();
  }
  public CSINodeDriver buildLastDriver() {
    return this.drivers.get(drivers.size() - 1).build();
  }
  public CSINodeDriver buildMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
    for (CSINodeDriverBuilder item: drivers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
    for (CSINodeDriverBuilder item: drivers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDrivers(List<CSINodeDriver> drivers) {
    if (this.drivers != null) { _visitables.get("drivers").removeAll(this.drivers);}
    if (drivers != null) {this.drivers = new ArrayList(); for (CSINodeDriver item : drivers){this.addToDrivers(item);}} else { this.drivers = null;} return (A) this;
  }
  public A withDrivers(io.fabric8.kubernetes.api.model.storage.v1beta1.CSINodeDriver... drivers) {
    if (this.drivers != null) {this.drivers.clear();}
    if (drivers != null) {for (CSINodeDriver item :drivers){ this.addToDrivers(item);}} return (A) this;
  }
  public Boolean hasDrivers() {
    return drivers != null && !drivers.isEmpty();
  }
  public CSINodeSpecFluent.DriversNested<A> addNewDriver() {
    return new CSINodeSpecFluentImpl.DriversNestedImpl();
  }
  public CSINodeSpecFluent.DriversNested<A> addNewDriverLike(CSINodeDriver item) {
    return new CSINodeSpecFluentImpl.DriversNestedImpl(-1, item);
  }
  public CSINodeSpecFluent.DriversNested<A> setNewDriverLike(Integer index,CSINodeDriver item) {
    return new CSINodeSpecFluentImpl.DriversNestedImpl(index, item);
  }
  public CSINodeSpecFluent.DriversNested<A> editDriver(Integer index) {
    if (drivers.size() <= index) throw new RuntimeException("Can't edit drivers. Index exceeds size.");
    return setNewDriverLike(index, buildDriver(index));
  }
  public CSINodeSpecFluent.DriversNested<A> editFirstDriver() {
    if (drivers.size() == 0) throw new RuntimeException("Can't edit first drivers. The list is empty.");
    return setNewDriverLike(0, buildDriver(0));
  }
  public CSINodeSpecFluent.DriversNested<A> editLastDriver() {
    int index = drivers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last drivers. The list is empty.");
    return setNewDriverLike(index, buildDriver(index));
  }
  public CSINodeSpecFluent.DriversNested<A> editMatchingDriver(Predicate<CSINodeDriverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<drivers.size();i++) { 
    if (predicate.test(drivers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching drivers. No match found.");
    return setNewDriverLike(index, buildDriver(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CSINodeSpecFluentImpl that = (CSINodeSpecFluentImpl) o;
    if (drivers != null ? !drivers.equals(that.drivers) :that.drivers != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(drivers,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (drivers != null && !drivers.isEmpty()) { sb.append("drivers:"); sb.append(drivers + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DriversNestedImpl<N> extends CSINodeDriverFluentImpl<CSINodeSpecFluent.DriversNested<N>> implements CSINodeSpecFluent.DriversNested<N>,Nested<N>{
    DriversNestedImpl(Integer index,CSINodeDriver item) {
      this.index = index;
      this.builder = new CSINodeDriverBuilder(this, item);
    }
    DriversNestedImpl() {
      this.index = -1;
      this.builder = new CSINodeDriverBuilder(this);
    }
    CSINodeDriverBuilder builder;
    Integer index;
    public N and() {
      return (N) CSINodeSpecFluentImpl.this.setToDrivers(index,builder.build());
    }
    public N endDriver() {
      return and();
    }
    
  }
  
}