package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CSINodeDriverBuilder extends CSINodeDriverFluentImpl<CSINodeDriverBuilder> implements VisitableBuilder<CSINodeDriver,CSINodeDriverBuilder>{
  public CSINodeDriverBuilder() {
    this(false);
  }
  public CSINodeDriverBuilder(Boolean validationEnabled) {
    this(new CSINodeDriver(), validationEnabled);
  }
  public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent) {
    this(fluent, false);
  }
  public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CSINodeDriver(), validationEnabled);
  }
  public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent,CSINodeDriver instance) {
    this(fluent, instance, false);
  }
  public CSINodeDriverBuilder(CSINodeDriverFluent<?> fluent,CSINodeDriver instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllocatable(instance.getAllocatable()); 
    fluent.withName(instance.getName()); 
    fluent.withNodeID(instance.getNodeID()); 
    fluent.withTopologyKeys(instance.getTopologyKeys()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CSINodeDriverBuilder(CSINodeDriver instance) {
    this(instance,false);
  }
  public CSINodeDriverBuilder(CSINodeDriver instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllocatable(instance.getAllocatable()); 
    this.withName(instance.getName()); 
    this.withNodeID(instance.getNodeID()); 
    this.withTopologyKeys(instance.getTopologyKeys()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CSINodeDriverFluent<?> fluent;
  Boolean validationEnabled;
  public CSINodeDriver build() {
    CSINodeDriver buildable = new CSINodeDriver(fluent.getAllocatable(),fluent.getName(),fluent.getNodeID(),fluent.getTopologyKeys());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}