package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CSIDriverSpecFluent<A extends CSIDriverSpecFluent<A>> extends Fluent<A>{
  public Boolean getAttachRequired();
  public A withAttachRequired(Boolean attachRequired);
  public Boolean hasAttachRequired();
  public String getFsGroupPolicy();
  public A withFsGroupPolicy(String fsGroupPolicy);
  public Boolean hasFsGroupPolicy();
  public Boolean getPodInfoOnMount();
  public A withPodInfoOnMount(Boolean podInfoOnMount);
  public Boolean hasPodInfoOnMount();
  public Boolean getRequiresRepublish();
  public A withRequiresRepublish(Boolean requiresRepublish);
  public Boolean hasRequiresRepublish();
  public Boolean getSeLinuxMount();
  public A withSeLinuxMount(Boolean seLinuxMount);
  public Boolean hasSeLinuxMount();
  public Boolean getStorageCapacity();
  public A withStorageCapacity(Boolean storageCapacity);
  public Boolean hasStorageCapacity();
  public A addToTokenRequests(Integer index,TokenRequest item);
  public A setToTokenRequests(Integer index,TokenRequest item);
  public A addToTokenRequests(io.fabric8.kubernetes.api.model.storage.v1beta1.TokenRequest... items);
  public A addAllToTokenRequests(Collection<TokenRequest> items);
  public A removeFromTokenRequests(io.fabric8.kubernetes.api.model.storage.v1beta1.TokenRequest... items);
  public A removeAllFromTokenRequests(Collection<TokenRequest> items);
  public A removeMatchingFromTokenRequests(Predicate<TokenRequestBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTokenRequests instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TokenRequest> getTokenRequests();
  public List<TokenRequest> buildTokenRequests();
  public TokenRequest buildTokenRequest(Integer index);
  public TokenRequest buildFirstTokenRequest();
  public TokenRequest buildLastTokenRequest();
  public TokenRequest buildMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate);
  public Boolean hasMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate);
  public A withTokenRequests(List<TokenRequest> tokenRequests);
  public A withTokenRequests(io.fabric8.kubernetes.api.model.storage.v1beta1.TokenRequest... tokenRequests);
  public Boolean hasTokenRequests();
  public A addNewTokenRequest(String audience,Long expirationSeconds);
  public CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequest();
  public CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequestLike(TokenRequest item);
  public CSIDriverSpecFluent.TokenRequestsNested<A> setNewTokenRequestLike(Integer index,TokenRequest item);
  public CSIDriverSpecFluent.TokenRequestsNested<A> editTokenRequest(Integer index);
  public CSIDriverSpecFluent.TokenRequestsNested<A> editFirstTokenRequest();
  public CSIDriverSpecFluent.TokenRequestsNested<A> editLastTokenRequest();
  public CSIDriverSpecFluent.TokenRequestsNested<A> editMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate);
  public A addToVolumeLifecycleModes(Integer index,String item);
  public A setToVolumeLifecycleModes(Integer index,String item);
  public A addToVolumeLifecycleModes(java.lang.String... items);
  public A addAllToVolumeLifecycleModes(Collection<String> items);
  public A removeFromVolumeLifecycleModes(java.lang.String... items);
  public A removeAllFromVolumeLifecycleModes(Collection<String> items);
  public List<String> getVolumeLifecycleModes();
  public String getVolumeLifecycleMode(Integer index);
  public String getFirstVolumeLifecycleMode();
  public String getLastVolumeLifecycleMode();
  public String getMatchingVolumeLifecycleMode(Predicate<String> predicate);
  public Boolean hasMatchingVolumeLifecycleMode(Predicate<String> predicate);
  public A withVolumeLifecycleModes(List<String> volumeLifecycleModes);
  public A withVolumeLifecycleModes(java.lang.String... volumeLifecycleModes);
  public Boolean hasVolumeLifecycleModes();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAttachRequired();
  public A withPodInfoOnMount();
  public A withRequiresRepublish();
  public A withSeLinuxMount();
  public A withStorageCapacity();
  public interface TokenRequestsNested<N> extends Nested<N>,TokenRequestFluent<CSIDriverSpecFluent.TokenRequestsNested<N>>{
    public N and();
    public N endTokenRequest();
    
  }
  
}