package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeErrorBuilder extends io.fabric8.kubernetes.api.model.storage.VolumeErrorFluentImpl<io.fabric8.kubernetes.api.model.storage.VolumeErrorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.storage.VolumeError,io.fabric8.kubernetes.api.model.storage.VolumeErrorBuilder> {

    io.fabric8.kubernetes.api.model.storage.VolumeErrorFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public VolumeErrorBuilder() {
        this(true);
    }

    public VolumeErrorBuilder(java.lang.Boolean validationEnabled) {
        this(new VolumeError(), validationEnabled);
    }

    public VolumeErrorBuilder(io.fabric8.kubernetes.api.model.storage.VolumeErrorFluent<?> fluent) {
        this(fluent, true);
    }

    public VolumeErrorBuilder(io.fabric8.kubernetes.api.model.storage.VolumeErrorFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new VolumeError(), validationEnabled);
    }

    public VolumeErrorBuilder(io.fabric8.kubernetes.api.model.storage.VolumeErrorFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.VolumeError instance) {
        this(fluent, instance, true);
    }

    public VolumeErrorBuilder(io.fabric8.kubernetes.api.model.storage.VolumeErrorFluent<?> fluent,io.fabric8.kubernetes.api.model.storage.VolumeError instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMessage(instance.getMessage()); 
        fluent.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeErrorBuilder(io.fabric8.kubernetes.api.model.storage.VolumeError instance) {
        this(instance,true);
    }

    public VolumeErrorBuilder(io.fabric8.kubernetes.api.model.storage.VolumeError instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMessage(instance.getMessage()); 
        this.withTime(instance.getTime()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeError build() {
        VolumeError buildable = new VolumeError(fluent.getMessage(),fluent.getTime());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VolumeErrorBuilder that = (VolumeErrorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
