package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSINodeSpecBuilder extends CSINodeSpecFluentImpl<CSINodeSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CSINodeSpec,CSINodeSpecBuilder> {

    CSINodeSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CSINodeSpecBuilder() {
        this(true);
    }

    public CSINodeSpecBuilder(Boolean validationEnabled) {
        this(new CSINodeSpec(), validationEnabled);
    }

    public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CSINodeSpec(), validationEnabled);
    }

    public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent,CSINodeSpec instance) {
        this(fluent, instance, true);
    }

    public CSINodeSpecBuilder(CSINodeSpecFluent<?> fluent,CSINodeSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDrivers(instance.getDrivers()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSINodeSpecBuilder(CSINodeSpec instance) {
        this(instance,true);
    }

    public CSINodeSpecBuilder(CSINodeSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDrivers(instance.getDrivers()); 
        this.validationEnabled = validationEnabled; 
    }

    public CSINodeSpec build() {
        CSINodeSpec buildable = new CSINodeSpec(fluent.getDrivers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSINodeSpecBuilder that = (CSINodeSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
