package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CSIDriverSpecFluent<A extends CSIDriverSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Boolean getAttachRequired();
    public A withAttachRequired(Boolean attachRequired);
    public Boolean hasAttachRequired();
    public A withNewAttachRequired(String arg1);
    public A withNewAttachRequired(boolean arg1);
    public String getFsGroupPolicy();
    public A withFsGroupPolicy(String fsGroupPolicy);
    public Boolean hasFsGroupPolicy();
    public A withNewFsGroupPolicy(StringBuilder arg1);
    public A withNewFsGroupPolicy(int[] arg1,int arg2,int arg3);
    public A withNewFsGroupPolicy(char[] arg1);
    public A withNewFsGroupPolicy(StringBuffer arg1);
    public A withNewFsGroupPolicy(byte[] arg1,int arg2);
    public A withNewFsGroupPolicy(byte[] arg1);
    public A withNewFsGroupPolicy(char[] arg1,int arg2,int arg3);
    public A withNewFsGroupPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewFsGroupPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewFsGroupPolicy(String arg1);
    public Boolean getPodInfoOnMount();
    public A withPodInfoOnMount(Boolean podInfoOnMount);
    public Boolean hasPodInfoOnMount();
    public A withNewPodInfoOnMount(String arg1);
    public A withNewPodInfoOnMount(boolean arg1);
    public Boolean getRequiresRepublish();
    public A withRequiresRepublish(Boolean requiresRepublish);
    public Boolean hasRequiresRepublish();
    public A withNewRequiresRepublish(String arg1);
    public A withNewRequiresRepublish(boolean arg1);
    public Boolean getStorageCapacity();
    public A withStorageCapacity(Boolean storageCapacity);
    public Boolean hasStorageCapacity();
    public A withNewStorageCapacity(String arg1);
    public A withNewStorageCapacity(boolean arg1);
    public A addToTokenRequests(int index,TokenRequest item);
    public A setToTokenRequests(int index,TokenRequest item);
    public A addToTokenRequests(TokenRequest... items);
    public A addAllToTokenRequests(Collection<TokenRequest> items);
    public A removeFromTokenRequests(TokenRequest... items);
    public A removeAllFromTokenRequests(Collection<TokenRequest> items);
    public A removeMatchingFromTokenRequests(Predicate<TokenRequestBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTokenRequests instead.
 * @return The buildable object.
 */
@Deprecated public List<TokenRequest> getTokenRequests();
    public List<TokenRequest> buildTokenRequests();
    public TokenRequest buildTokenRequest(int index);
    public TokenRequest buildFirstTokenRequest();
    public TokenRequest buildLastTokenRequest();
    public TokenRequest buildMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate);
    public Boolean hasMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate);
    public A withTokenRequests(List<TokenRequest> tokenRequests);
    public A withTokenRequests(TokenRequest... tokenRequests);
    public Boolean hasTokenRequests();
    public A addNewTokenRequest(String audience,Long expirationSeconds);
    public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequest();
    public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequestLike(TokenRequest item);
    public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecFluent.TokenRequestsNested<A> setNewTokenRequestLike(int index,TokenRequest item);
    public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecFluent.TokenRequestsNested<A> editTokenRequest(int index);
    public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecFluent.TokenRequestsNested<A> editFirstTokenRequest();
    public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecFluent.TokenRequestsNested<A> editLastTokenRequest();
    public io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecFluent.TokenRequestsNested<A> editMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate);
    public A addToVolumeLifecycleModes(int index,String item);
    public A setToVolumeLifecycleModes(int index,String item);
    public A addToVolumeLifecycleModes(String... items);
    public A addAllToVolumeLifecycleModes(Collection<String> items);
    public A removeFromVolumeLifecycleModes(String... items);
    public A removeAllFromVolumeLifecycleModes(Collection<String> items);
    public List<String> getVolumeLifecycleModes();
    public String getVolumeLifecycleMode(int index);
    public String getFirstVolumeLifecycleMode();
    public String getLastVolumeLifecycleMode();
    public String getMatchingVolumeLifecycleMode(Predicate<String> predicate);
    public Boolean hasMatchingVolumeLifecycleMode(Predicate<String> predicate);
    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes);
    public A withVolumeLifecycleModes(String... volumeLifecycleModes);
    public Boolean hasVolumeLifecycleModes();
    public A addNewVolumeLifecycleMode(StringBuilder arg1);
    public A addNewVolumeLifecycleMode(int[] arg1,int arg2,int arg3);
    public A addNewVolumeLifecycleMode(char[] arg1);
    public A addNewVolumeLifecycleMode(StringBuffer arg1);
    public A addNewVolumeLifecycleMode(byte[] arg1,int arg2);
    public A addNewVolumeLifecycleMode(byte[] arg1);
    public A addNewVolumeLifecycleMode(char[] arg1,int arg2,int arg3);
    public A addNewVolumeLifecycleMode(byte[] arg1,int arg2,int arg3);
    public A addNewVolumeLifecycleMode(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewVolumeLifecycleMode(String arg1);
    public interface TokenRequestsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TokenRequestFluent<io.fabric8.kubernetes.api.model.storage.v1beta1.CSIDriverSpecFluent.TokenRequestsNested<N>> {

            public N and();
            public N endTokenRequest();    }


}
