package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VolumeAttachmentSpecBuilder extends VolumeAttachmentSpecFluentImpl<VolumeAttachmentSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<VolumeAttachmentSpec,VolumeAttachmentSpecBuilder> {

    VolumeAttachmentSpecFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeAttachmentSpecBuilder() {
        this(true);
    }

    public VolumeAttachmentSpecBuilder(Boolean validationEnabled) {
        this(new VolumeAttachmentSpec(), validationEnabled);
    }

    public VolumeAttachmentSpecBuilder(VolumeAttachmentSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public VolumeAttachmentSpecBuilder(VolumeAttachmentSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new VolumeAttachmentSpec(), validationEnabled);
    }

    public VolumeAttachmentSpecBuilder(VolumeAttachmentSpecFluent<?> fluent,VolumeAttachmentSpec instance) {
        this(fluent, instance, true);
    }

    public VolumeAttachmentSpecBuilder(VolumeAttachmentSpecFluent<?> fluent,VolumeAttachmentSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAttacher(instance.getAttacher()); 
        fluent.withNodeName(instance.getNodeName()); 
        fluent.withSource(instance.getSource()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeAttachmentSpecBuilder(VolumeAttachmentSpec instance) {
        this(instance,true);
    }

    public VolumeAttachmentSpecBuilder(VolumeAttachmentSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAttacher(instance.getAttacher()); 
        this.withNodeName(instance.getNodeName()); 
        this.withSource(instance.getSource()); 
        this.validationEnabled = validationEnabled; 
    }

    public VolumeAttachmentSpec build() {
        VolumeAttachmentSpec buildable = new VolumeAttachmentSpec(fluent.getAttacher(),fluent.getNodeName(),fluent.getSource());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VolumeAttachmentSpecBuilder that = (VolumeAttachmentSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
