package io.fabric8.kubernetes.api.model.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class VolumeAttachmentStatusFluentImpl<A extends VolumeAttachmentStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements VolumeAttachmentStatusFluent<A> {

    private VolumeErrorBuilder attachError;
    private Boolean attached;
    private java.util.Map<String,String> attachmentMetadata;
    private VolumeErrorBuilder detachError;

    public VolumeAttachmentStatusFluentImpl() {
    }

    public VolumeAttachmentStatusFluentImpl(VolumeAttachmentStatus instance) {
        this.withAttachError(instance.getAttachError()); 
        this.withAttached(instance.getAttached()); 
        this.withAttachmentMetadata(instance.getAttachmentMetadata()); 
        this.withDetachError(instance.getDetachError()); 
    }

    
/**
 * This method has been deprecated, please use method buildAttachError instead.
 * @return The buildable object.
 */
@Deprecated public VolumeError getAttachError() {
        return this.attachError!=null?this.attachError.build():null;
    }

    public VolumeError buildAttachError() {
        return this.attachError!=null?this.attachError.build():null;
    }

    public A withAttachError(VolumeError attachError) {
        _visitables.get("attachError").remove(this.attachError);
        if (attachError!=null){ this.attachError= new VolumeErrorBuilder(attachError); _visitables.get("attachError").add(this.attachError);} return (A) this;
    }

    public Boolean hasAttachError() {
        return this.attachError != null;
    }

    public A withNewAttachError(String message,String time) {
        return (A)withAttachError(new VolumeError(message, time));
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.AttachErrorNested<A> withNewAttachError() {
        return new AttachErrorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.AttachErrorNested<A> withNewAttachErrorLike(VolumeError item) {
        return new AttachErrorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.AttachErrorNested<A> editAttachError() {
        return withNewAttachErrorLike(getAttachError());
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.AttachErrorNested<A> editOrNewAttachError() {
        return withNewAttachErrorLike(getAttachError() != null ? getAttachError(): new VolumeErrorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.AttachErrorNested<A> editOrNewAttachErrorLike(VolumeError item) {
        return withNewAttachErrorLike(getAttachError() != null ? getAttachError(): item);
    }

    public Boolean getAttached() {
        return this.attached;
    }

    public A withAttached(Boolean attached) {
        this.attached=attached; return (A) this;
    }

    public Boolean hasAttached() {
        return this.attached != null;
    }

    public A withNewAttached(String arg1) {
        return (A)withAttached(new Boolean(arg1));
    }

    public A withNewAttached(boolean arg1) {
        return (A)withAttached(new Boolean(arg1));
    }

    public A addToAttachmentMetadata(String key,String value) {
        if(this.attachmentMetadata == null && key != null && value != null) { this.attachmentMetadata = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.attachmentMetadata.put(key, value);} return (A)this;
    }

    public A addToAttachmentMetadata(java.util.Map<String,String> map) {
        if(this.attachmentMetadata == null && map != null) { this.attachmentMetadata = new LinkedHashMap<String,String>(); }
        if(map != null) { this.attachmentMetadata.putAll(map);} return (A)this;
    }

    public A removeFromAttachmentMetadata(String key) {
        if(this.attachmentMetadata == null) { return (A) this; }
        if(key != null && this.attachmentMetadata != null) {this.attachmentMetadata.remove(key);} return (A)this;
    }

    public A removeFromAttachmentMetadata(java.util.Map<String,String> map) {
        if(this.attachmentMetadata == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.attachmentMetadata != null){this.attachmentMetadata.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    public <K extends Object,V extends Object>A withAttachmentMetadata(java.util.Map<String,String> attachmentMetadata) {
        if (attachmentMetadata == null) { this.attachmentMetadata =  null;} else {this.attachmentMetadata = new LinkedHashMap<String,String>(attachmentMetadata);} return (A) this;
    }

    public Boolean hasAttachmentMetadata() {
        return this.attachmentMetadata != null;
    }

    
/**
 * This method has been deprecated, please use method buildDetachError instead.
 * @return The buildable object.
 */
@Deprecated public VolumeError getDetachError() {
        return this.detachError!=null?this.detachError.build():null;
    }

    public VolumeError buildDetachError() {
        return this.detachError!=null?this.detachError.build():null;
    }

    public A withDetachError(VolumeError detachError) {
        _visitables.get("detachError").remove(this.detachError);
        if (detachError!=null){ this.detachError= new VolumeErrorBuilder(detachError); _visitables.get("detachError").add(this.detachError);} return (A) this;
    }

    public Boolean hasDetachError() {
        return this.detachError != null;
    }

    public A withNewDetachError(String message,String time) {
        return (A)withDetachError(new VolumeError(message, time));
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.DetachErrorNested<A> withNewDetachError() {
        return new DetachErrorNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.DetachErrorNested<A> withNewDetachErrorLike(VolumeError item) {
        return new DetachErrorNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.DetachErrorNested<A> editDetachError() {
        return withNewDetachErrorLike(getDetachError());
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.DetachErrorNested<A> editOrNewDetachError() {
        return withNewDetachErrorLike(getDetachError() != null ? getDetachError(): new VolumeErrorBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.DetachErrorNested<A> editOrNewDetachErrorLike(VolumeError item) {
        return withNewDetachErrorLike(getDetachError() != null ? getDetachError(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VolumeAttachmentStatusFluentImpl that = (VolumeAttachmentStatusFluentImpl) o;
        if (attachError != null ? !attachError.equals(that.attachError) :that.attachError != null) return false;
        if (attached != null ? !attached.equals(that.attached) :that.attached != null) return false;
        if (attachmentMetadata != null ? !attachmentMetadata.equals(that.attachmentMetadata) :that.attachmentMetadata != null) return false;
        if (detachError != null ? !detachError.equals(that.detachError) :that.detachError != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(attachError,  attached,  attachmentMetadata,  detachError,  super.hashCode());
    }

    public class AttachErrorNestedImpl<N> extends VolumeErrorFluentImpl<io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.AttachErrorNested<N>> implements io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.AttachErrorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeErrorBuilder builder;

            AttachErrorNestedImpl(VolumeError item) {
                this.builder = new VolumeErrorBuilder(this, item);
                        
            }

            AttachErrorNestedImpl() {
                this.builder = new VolumeErrorBuilder(this);
                        
            }

            public N and() {
                return (N) VolumeAttachmentStatusFluentImpl.this.withAttachError(builder.build());
            }

            public N endAttachError() {
                return and();
            }
    }


    public class DetachErrorNestedImpl<N> extends VolumeErrorFluentImpl<io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.DetachErrorNested<N>> implements io.fabric8.kubernetes.api.model.storage.VolumeAttachmentStatusFluent.DetachErrorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeErrorBuilder builder;

            DetachErrorNestedImpl(VolumeError item) {
                this.builder = new VolumeErrorBuilder(this, item);
                        
            }

            DetachErrorNestedImpl() {
                this.builder = new VolumeErrorBuilder(this);
                        
            }

            public N and() {
                return (N) VolumeAttachmentStatusFluentImpl.this.withDetachError(builder.build());
            }

            public N endDetachError() {
                return and();
            }
    }


}
