package io.fabric8.kubernetes.api.model.storage;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.TopologySelectorTerm;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface StorageClassFluent<A extends StorageClassFluent<A>> extends Fluent<A> {


    public Boolean isAllowVolumeExpansion();
    public A withAllowVolumeExpansion(Boolean allowVolumeExpansion);
    public Boolean hasAllowVolumeExpansion();
    public A withNewAllowVolumeExpansion(String arg1);
    public A withNewAllowVolumeExpansion(boolean arg1);
    public A addToAllowedTopologies(int index,TopologySelectorTerm item);
    public A setToAllowedTopologies(int index,TopologySelectorTerm item);
    public A addToAllowedTopologies(TopologySelectorTerm... items);
    public A addAllToAllowedTopologies(Collection<TopologySelectorTerm> items);
    public A removeFromAllowedTopologies(TopologySelectorTerm... items);
    public A removeAllFromAllowedTopologies(Collection<TopologySelectorTerm> items);
    public List<TopologySelectorTerm> getAllowedTopologies();
    public TopologySelectorTerm getAllowedTopology(int index);
    public TopologySelectorTerm getFirstAllowedTopology();
    public TopologySelectorTerm getLastAllowedTopology();
    public TopologySelectorTerm getMatchingAllowedTopology(Predicate<TopologySelectorTerm> predicate);
    public Boolean hasMatchingAllowedTopology(Predicate<TopologySelectorTerm> predicate);
    public A withAllowedTopologies(List<TopologySelectorTerm> allowedTopologies);
    public A withAllowedTopologies(TopologySelectorTerm... allowedTopologies);
    public Boolean hasAllowedTopologies();
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public StorageClassFluent.MetadataNested<A> withNewMetadata();
    public StorageClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public StorageClassFluent.MetadataNested<A> editMetadata();
    public StorageClassFluent.MetadataNested<A> editOrNewMetadata();
    public StorageClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToMountOptions(int index,String item);
    public A setToMountOptions(int index,String item);
    public A addToMountOptions(String... items);
    public A addAllToMountOptions(Collection<String> items);
    public A removeFromMountOptions(String... items);
    public A removeAllFromMountOptions(Collection<String> items);
    public List<String> getMountOptions();
    public String getMountOption(int index);
    public String getFirstMountOption();
    public String getLastMountOption();
    public String getMatchingMountOption(Predicate<String> predicate);
    public Boolean hasMatchingMountOption(Predicate<String> predicate);
    public A withMountOptions(List<String> mountOptions);
    public A withMountOptions(String... mountOptions);
    public Boolean hasMountOptions();
    public A addNewMountOption(String arg1);
    public A addNewMountOption(StringBuilder arg1);
    public A addNewMountOption(StringBuffer arg1);
    public A addToParameters(String key,String value);
    public A addToParameters(Map<String,String> map);
    public A removeFromParameters(String key);
    public A removeFromParameters(Map<String,String> map);
    public Map<String,String> getParameters();
    public A withParameters(Map<String,String> parameters);
    public Boolean hasParameters();
    public String getProvisioner();
    public A withProvisioner(String provisioner);
    public Boolean hasProvisioner();
    public A withNewProvisioner(String arg1);
    public A withNewProvisioner(StringBuilder arg1);
    public A withNewProvisioner(StringBuffer arg1);
    public String getReclaimPolicy();
    public A withReclaimPolicy(String reclaimPolicy);
    public Boolean hasReclaimPolicy();
    public A withNewReclaimPolicy(String arg1);
    public A withNewReclaimPolicy(StringBuilder arg1);
    public A withNewReclaimPolicy(StringBuffer arg1);
    public String getVolumeBindingMode();
    public A withVolumeBindingMode(String volumeBindingMode);
    public Boolean hasVolumeBindingMode();
    public A withNewVolumeBindingMode(String arg1);
    public A withNewVolumeBindingMode(StringBuilder arg1);
    public A withNewVolumeBindingMode(StringBuffer arg1);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<StorageClassFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
