package io.fabric8.kubernetes.api.model.storage.v1beta1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class TokenRequestFluentImpl<A extends TokenRequestFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TokenRequestFluent<A> {

    private String audience;
    private Long expirationSeconds;

    public TokenRequestFluentImpl() {
    }

    public TokenRequestFluentImpl(TokenRequest instance) {
        this.withAudience(instance.getAudience()); 
        this.withExpirationSeconds(instance.getExpirationSeconds()); 
    }

    public String getAudience() {
        return this.audience;
    }

    public A withAudience(String audience) {
        this.audience=audience; return (A) this;
    }

    public Boolean hasAudience() {
        return this.audience != null;
    }

    public A withNewAudience(String arg1) {
        return (A)withAudience(new String(arg1));
    }

    public A withNewAudience(StringBuilder arg1) {
        return (A)withAudience(new String(arg1));
    }

    public A withNewAudience(StringBuffer arg1) {
        return (A)withAudience(new String(arg1));
    }

    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public A withExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds=expirationSeconds; return (A) this;
    }

    public Boolean hasExpirationSeconds() {
        return this.expirationSeconds != null;
    }

    public A withNewExpirationSeconds(String arg1) {
        return (A)withExpirationSeconds(new Long(arg1));
    }

    public A withNewExpirationSeconds(long arg1) {
        return (A)withExpirationSeconds(new Long(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TokenRequestFluentImpl that = (TokenRequestFluentImpl) o;
        if (audience != null ? !audience.equals(that.audience) :that.audience != null) return false;
        if (expirationSeconds != null ? !expirationSeconds.equals(that.expirationSeconds) :that.expirationSeconds != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(audience,  expirationSeconds,  super.hashCode());
    }

}
