package io.fabric8.kubernetes.api.model.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface CSINodeSpecFluent<A extends CSINodeSpecFluent<A>> extends Fluent<A> {


    public A addToDrivers(int index,CSINodeDriver item);
    public A setToDrivers(int index,CSINodeDriver item);
    public A addToDrivers(CSINodeDriver... items);
    public A addAllToDrivers(Collection<CSINodeDriver> items);
    public A removeFromDrivers(CSINodeDriver... items);
    public A removeAllFromDrivers(Collection<CSINodeDriver> items);
    public A removeMatchingFromDrivers(Predicate<CSINodeDriverBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildDrivers instead.
 * @return The buildable object.
 */
@Deprecated public List<CSINodeDriver> getDrivers();
    public List<CSINodeDriver> buildDrivers();
    public CSINodeDriver buildDriver(int index);
    public CSINodeDriver buildFirstDriver();
    public CSINodeDriver buildLastDriver();
    public CSINodeDriver buildMatchingDriver(Predicate<CSINodeDriverBuilder> predicate);
    public Boolean hasMatchingDriver(Predicate<CSINodeDriverBuilder> predicate);
    public A withDrivers(List<CSINodeDriver> drivers);
    public A withDrivers(CSINodeDriver... drivers);
    public Boolean hasDrivers();
    public CSINodeSpecFluent.DriversNested<A> addNewDriver();
    public CSINodeSpecFluent.DriversNested<A> addNewDriverLike(CSINodeDriver item);
    public CSINodeSpecFluent.DriversNested<A> setNewDriverLike(int index,CSINodeDriver item);
    public CSINodeSpecFluent.DriversNested<A> editDriver(int index);
    public CSINodeSpecFluent.DriversNested<A> editFirstDriver();
    public CSINodeSpecFluent.DriversNested<A> editLastDriver();
    public CSINodeSpecFluent.DriversNested<A> editMatchingDriver(Predicate<CSINodeDriverBuilder> predicate);
    public interface DriversNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSINodeDriverFluent<CSINodeSpecFluent.DriversNested<N>> {

            public N and();
            public N endDriver();    }


}
